/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common;

import com.axelor.common.ClassUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Properties;

public final class ResourceUtils {
    public static URL getResource(String location) {
        return ClassUtils.getResource(location);
    }

    public static InputStream getResourceStream(String location) {
        URL url = ResourceUtils.getResource(location);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Properties getProperties(URL file) throws IOException {
        Objects.requireNonNull(file, "file cannot be null");
        Properties properties = new Properties();
        try (InputStream is = file.openStream();){
            properties.load(is);
        }
        return properties;
    }

    public static Properties getProperties(File file) throws IOException {
        Objects.requireNonNull(file, "file cannot be null");
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(file);){
            properties.load(is);
        }
        return properties;
    }
}

