/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common;

import java.text.Normalizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringUtils {
    public static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static boolean notEmpty(CharSequence value) {
        return !StringUtils.isEmpty(value);
    }

    public static boolean isBlank(CharSequence value) {
        if (StringUtils.isEmpty(value)) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean notBlank(CharSequence value) {
        return !StringUtils.isBlank(value);
    }

    public static String stripAccent(CharSequence value) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isEmpty(value)) {
            return value.toString();
        }
        return Normalizer.normalize(value, Normalizer.Form.NFD).replace('\u0141', 'L').replace('\u0142', 'l').replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String stripIndent(CharSequence text) {
        if (text == null) {
            return null;
        }
        if (StringUtils.isBlank(text)) {
            return text.toString();
        }
        String[] lines = text.toString().split("\\n");
        StringBuilder builder = new StringBuilder();
        int leading = -1;
        for (String line : lines) {
            if (StringUtils.isBlank(line)) continue;
            int index = 0;
            int length = line.length();
            if (leading == -1) {
                leading = length;
            }
            while (index < length && index < leading && Character.isWhitespace(line.charAt(index))) {
                ++index;
            }
            if (leading <= index) continue;
            leading = index;
        }
        for (String line : lines) {
            if (!StringUtils.isBlank(line)) {
                builder.append(leading <= line.length() ? line.substring(leading) : "");
            }
            if (lines.length <= 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String stripMargin(CharSequence text) {
        if (text == null) {
            return null;
        }
        return Stream.of(text.toString().split("\n")).map(line -> line.replaceFirst("^\\s+\\|", "")).collect(Collectors.joining("\n"));
    }
}

