/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.crypto;

import com.axelor.common.crypto.Encryptor;
import com.axelor.common.crypto.EncryptorException;
import com.axelor.common.crypto.OperationMode;
import com.axelor.common.crypto.PaddingScheme;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class BytesEncryptor
implements Encryptor<byte[], byte[]> {
    private static final String AES_ALGORITHM = "AES";
    private static final String KEY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final int IV_SIZE = 16;
    private static final int SALT_SIZE = 8;
    private static final int TAG_BIT_LENGTH = 128;
    static final String PREFIX = "$AES$";
    static final byte[] PREFIX_BYTES = "$AES$".getBytes();
    private final OperationMode mode;
    private final String password;
    private final String transformation;
    private final byte[] encryptionSalt;
    private final SecretKey encryptionKey;
    private final int payloadSize;

    public BytesEncryptor(OperationMode mode, PaddingScheme paddingScheme, String password) {
        this.mode = mode;
        this.password = password;
        this.transformation = String.format("%s/%s/%s", new Object[]{AES_ALGORITHM, mode, paddingScheme});
        this.encryptionSalt = this.generateRandomBytes(8);
        this.encryptionKey = this.newSecretKey(password, this.encryptionSalt);
        this.payloadSize = mode == OperationMode.CBC ? PREFIX_BYTES.length + 8 : PREFIX_BYTES.length + 8 + 16;
    }

    public BytesEncryptor(String password) {
        this(OperationMode.CBC, PaddingScheme.PKCS5, password);
    }

    public static BytesEncryptor cbc(String password) {
        return new BytesEncryptor(OperationMode.CBC, PaddingScheme.PKCS5, password);
    }

    public static BytesEncryptor gcm(String password) {
        return new BytesEncryptor(OperationMode.GCM, PaddingScheme.NONE, password);
    }

    public String getTransformation() {
        return this.transformation;
    }

    private byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        SECURE_RANDOM.nextBytes(bytes);
        return bytes;
    }

    private SecretKey newSecretKey(String password, byte[] salt) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), salt, 1024, 256);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGORITHM);
            SecretKey tmp = keyFactory.generateSecret(keySpec);
            return new SecretKeySpec(tmp.getEncoded(), AES_ALGORITHM);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    private AlgorithmParameterSpec newParameterSpec(byte[] iv) {
        return this.mode == OperationMode.CBC ? new IvParameterSpec(iv) : new GCMParameterSpec(128, iv);
    }

    private Cipher newCipher(int mode, SecretKey key, byte[] iv) {
        try {
            AlgorithmParameterSpec paramSpec = this.newParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(this.transformation);
            cipher.init(mode, (Key)key, paramSpec);
            return cipher;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    private byte[] doFinal(Cipher cipher, byte[] data) {
        try {
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    @Override
    public boolean isEncrypted(byte[] bytes) {
        if (bytes == null || bytes.length < this.payloadSize) {
            return false;
        }
        byte[] prefix = new byte[PREFIX_BYTES.length];
        System.arraycopy(bytes, 0, prefix, 0, prefix.length);
        return Arrays.equals(prefix, PREFIX_BYTES);
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        if (bytes == null || this.isEncrypted(bytes)) {
            return bytes;
        }
        byte[] iv = this.mode == OperationMode.CBC ? new byte[16] : this.generateRandomBytes(16);
        Cipher cipher = this.newCipher(1, this.encryptionKey, iv);
        byte[] encrypted = this.doFinal(cipher, bytes);
        return this.mode == OperationMode.CBC ? Bytes.concat((byte[][])new byte[][]{PREFIX_BYTES, this.encryptionSalt, encrypted}) : Bytes.concat((byte[][])new byte[][]{PREFIX_BYTES, this.encryptionSalt, iv, encrypted});
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        if (bytes == null || !this.isEncrypted(bytes)) {
            return bytes;
        }
        byte[] salt = new byte[8];
        byte[] iv = new byte[16];
        byte[] data = new byte[bytes.length - this.payloadSize];
        List<byte[]> sections = this.mode == OperationMode.CBC ? Arrays.asList(salt, data) : Arrays.asList(salt, iv, data);
        int index = PREFIX_BYTES.length;
        for (byte[] section : sections) {
            System.arraycopy(bytes, index, section, 0, section.length);
            index += section.length;
        }
        SecretKey key = this.newSecretKey(this.password, salt);
        Cipher cipher = this.newCipher(2, key, iv);
        return this.doFinal(cipher, data);
    }

    public String toString() {
        return MoreObjects.toStringHelper(BytesEncryptor.class).addValue((Object)this.transformation).toString();
    }
}

