/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.jansi.Ansi;

public class ColorConverter
extends CompositeConverter<ILoggingEvent> {
    private static final Map<String, Ansi.Color> ELEMENTS;
    private static final Map<Integer, Ansi.Color> LEVELS;

    protected String transform(ILoggingEvent event, String in) {
        if (System.console() == null) {
            return in;
        }
        Ansi.Color color = ELEMENTS.get(this.getFirstOption());
        if (color == null) {
            color = LEVELS.get(event.getLevel().toInteger());
            color = color == null ? Ansi.Color.GREEN : color;
        }
        Ansi ansi = Ansi.ansi();
        if (color == Ansi.Color.DEFAULT) {
            ansi.a(Ansi.Attribute.INTENSITY_FAINT);
        }
        return ansi.fg(color).a(in).reset().toString();
    }

    static {
        HashMap<String, Ansi.Color> elements = new HashMap<String, Ansi.Color>();
        elements.put("faint", Ansi.Color.DEFAULT);
        elements.put("red", Ansi.Color.RED);
        elements.put("green", Ansi.Color.GREEN);
        elements.put("yellow", Ansi.Color.YELLOW);
        elements.put("blue", Ansi.Color.BLUE);
        elements.put("magenta", Ansi.Color.MAGENTA);
        elements.put("cyan", Ansi.Color.CYAN);
        ELEMENTS = Collections.unmodifiableMap(elements);
        HashMap<Integer, Ansi.Color> levels = new HashMap<Integer, Ansi.Color>();
        levels.put(Level.ERROR_INTEGER, Ansi.Color.RED);
        levels.put(Level.WARN_INTEGER, Ansi.Color.YELLOW);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

