/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.reflections;

import com.axelor.common.ClassUtils;
import com.axelor.common.reflections.ClassScanner;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class ClassFinder<T> {
    private Class<T> type;
    private ClassLoader loader;
    private Set<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
    private Set<String> packages = new LinkedHashSet<String>();
    private Set<String> pathPatterns = new LinkedHashSet<String>();
    private boolean matchAll = true;

    ClassFinder(Class<T> type, ClassLoader loader) {
        this.type = type;
        this.loader = loader;
    }

    ClassFinder(Class<T> type) {
        this(type, ClassUtils.getDefaultClassLoader());
    }

    public ClassFinder<T> byURL(String pattern) {
        Objects.requireNonNull(pattern, "pattern must not be null");
        this.pathPatterns.add(pattern);
        return this;
    }

    public ClassFinder<T> within(String packageName) {
        this.packages.add(packageName);
        return this;
    }

    public ClassFinder<?> using(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    public ClassFinder<T> having(Class<? extends Annotation> annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public ClassFinder<T> any() {
        this.matchAll = false;
        return this;
    }

    private boolean hasAnnotation(Class<?> cls) {
        boolean matched = false;
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (cls.isAnnotationPresent(annotation)) {
                if (!this.matchAll) {
                    return true;
                }
                matched = true;
                continue;
            }
            if (!this.matchAll) continue;
            return false;
        }
        return this.annotations.size() == 0 || matched;
    }

    public Set<Class<? extends T>> find() {
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        ClassScanner scanner = new ClassScanner(this.loader, this.packages.toArray(new String[0]));
        for (String string : this.pathPatterns) {
            scanner.byURL(string);
        }
        if (Object.class == this.type && this.annotations.isEmpty()) {
            throw new IllegalStateException("please provide some annnotations.");
        }
        if (Object.class == this.type) {
            for (Class clazz : this.annotations) {
                for (Class<?> c : scanner.getTypesAnnotatedWith(clazz)) {
                    if (!this.type.isAssignableFrom(c)) continue;
                    classes.add(c.asSubclass(this.type));
                }
            }
            return Collections.unmodifiableSet(classes);
        }
        Set<Class<T>> all = scanner.getSubTypesOf(this.type);
        for (Class<T> cls : all) {
            if (!this.hasAnnotation(cls)) continue;
            classes.add(cls);
        }
        return Collections.unmodifiableSet(classes);
    }
}

