/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.reflections;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceFinder {
    private ClassLoader loader;
    private Set<Pattern> namePatterns = new LinkedHashSet<Pattern>();
    private Set<Pattern> pathPatterns = new LinkedHashSet<Pattern>();

    ResourceFinder() {
    }

    ResourceFinder(ClassLoader loader) {
        this.loader = loader;
    }

    public ResourceFinder byName(String pattern) {
        Objects.requireNonNull(pattern, "pattern must not be null");
        this.namePatterns.add(Pattern.compile(pattern));
        return this;
    }

    public ResourceFinder byURL(String pattern) {
        Objects.requireNonNull(pattern, "pattern must not be null");
        this.pathPatterns.add(Pattern.compile(pattern));
        return this;
    }

    public List<URL> match() {
        return this.find(Matcher::matches);
    }

    public List<URL> find() {
        return this.find(Matcher::find);
    }

    private List<URL> find(Predicate<Matcher> matchFunc) {
        ArrayList<URL> all = new ArrayList<URL>();
        for (Pattern namePattern : this.namePatterns) {
            for (URL file : ResourceFinder.getResources(namePattern, this.loader, matchFunc)) {
                if (this.pathPatterns.isEmpty()) {
                    all.add(file);
                    continue;
                }
                for (Pattern pathPattern : this.pathPatterns) {
                    Matcher matcher = pathPattern.matcher(file.getFile());
                    boolean matched = matchFunc.test(matcher);
                    if (!matched) continue;
                    all.add(file);
                }
            }
        }
        return Collections.unmodifiableList(all);
    }

    private static List<URL> getResources(Pattern pattern, ClassLoader loader, Predicate<Matcher> matchFunc) {
        ArrayList<URL> all = new ArrayList<URL>();
        ClassLoader classLoader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        try {
            for (ClassPath.ResourceInfo info : ClassPath.from((ClassLoader)classLoader).getResources()) {
                String name = info.getResourceName();
                Matcher matcher = pattern.matcher(name);
                boolean matched = matchFunc.test(matcher);
                if (!matched) continue;
                Enumeration<URL> urls = classLoader.getResources(name);
                while (urls.hasMoreElements()) {
                    all.add(urls.nextElement());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(all);
    }
}

