/*
 * Decompiled with CFR 0.152.
 */
package io.buji.pac4j.context;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.Session;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShiroSessionStore
implements SessionStore<J2EContext> {
    private static final Logger logger = LoggerFactory.getLogger(ShiroSessionStore.class);
    public static final ShiroSessionStore INSTANCE = new ShiroSessionStore();

    protected Session getSession(boolean createSession) {
        return SecurityUtils.getSubject().getSession(createSession);
    }

    public String getOrCreateSessionId(J2EContext context) {
        Session session = this.getSession(true);
        if (session != null) {
            return session.getId().toString();
        }
        return null;
    }

    public Object get(J2EContext context, String key) {
        Session session = this.getSession(false);
        if (session != null) {
            return session.getAttribute((Object)key);
        }
        return null;
    }

    public void set(J2EContext context, String key, Object value) {
        Session session = this.getSession(true);
        if (session != null) {
            try {
                session.setAttribute((Object)key, value);
            }
            catch (UnavailableSecurityManagerException e) {
                logger.warn("Should happen just once at startup in some specific case of Shiro Spring configuration", (Throwable)e);
            }
        }
    }

    public boolean destroySession(J2EContext context) {
        this.getSession(true).stop();
        return true;
    }

    public Object getTrackableSession(J2EContext context) {
        return null;
    }

    public SessionStore<J2EContext> buildFromTrackableSession(J2EContext context, Object trackableSession) {
        return null;
    }

    public boolean renewSession(J2EContext context) {
        return false;
    }
}

