/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businesssupport.db;

import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BUSINESSSUPPORT_PROJECT_ANNOUNCEMENT", indexes={@Index(columnList="project")})
public class ProjectAnnouncement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BUSINESSSUPPORT_PROJECT_ANNOUNCEMENT_SEQ")
    @SequenceGenerator(name="BUSINESSSUPPORT_PROJECT_ANNOUNCEMENT_SEQ", sequenceName="BUSINESSSUPPORT_PROJECT_ANNOUNCEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title")
    private String title;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Content")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String content;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectAnnouncement)) {
            return false;
        }
        ProjectAnnouncement other = (ProjectAnnouncement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("date", (Object)this.getDate()).omitNullValues().toString();
    }
}

