/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.contract.db.ConsumptionLine;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.contract.db.InvoicePeriod;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONTRACT_CONTRACT", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="partner"), @Index(columnList="terminated_by_user"), @Index(columnList="current_invoice_period"), @Index(columnList="currency"), @Index(columnList="current_contract_version"), @Index(columnList="next_version"), @Index(columnList="project")})
public class Contract
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTRACT_CONTRACT_SEQ")
    @SequenceGenerator(name="CONTRACT_CONTRACT_SEQ", sequenceName="CONTRACT_CONTRACT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Type", selection="contract.target.type.select")
    @NotNull
    private Integer targetTypeSelect = 1;
    @Widget(title="Number of finished periods")
    private Integer periodNumber = 0;
    @Widget(title="Status", selection="contract.status.select")
    @NotNull
    private Integer statusSelect = 1;
    @Widget(title="Number of renewal")
    private Integer renewalNumber = 0;
    @Widget(title="Contract version")
    private Integer versionNumber = -1;
    @Widget(title="Name")
    @NameColumn
    private String name;
    @Widget(title="Notes", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String note;
    @Widget(title="Contract N\u00b0", readonly=true)
    private String contractId;
    @Widget(title="Manage invoices")
    private Boolean isInvoicingManagement = Boolean.FALSE;
    @Widget(title="Consumption management")
    private Boolean isConsumptionManagement = Boolean.FALSE;
    @Widget(title="Additional benefit management")
    private Boolean isAdditionaBenefitManagement = Boolean.FALSE;
    @Widget(title="To closed")
    private Boolean toClosed = Boolean.FALSE;
    @Widget(title="Terminated manually")
    private Boolean terminatedManually = Boolean.FALSE;
    @Widget(title="First period end date")
    private LocalDate firstPeriodEndDate;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Terminated date")
    private LocalDate terminatedDate;
    @Widget(title="Engagement start date")
    private LocalDate engagementStartDate;
    @Widget(title="Termination demand date")
    private LocalDate terminationDemandDate;
    @Widget(title="Last renewal date")
    private LocalDate lastRenewalDate;
    @Widget(title="Start of next invoicing period")
    private LocalDate invoicePeriodStartDate;
    @Widget(title="End of next invoicing period")
    private LocalDate invoicePeriodEndDate;
    @Widget(title="Invoicing date")
    private LocalDate invoicingDate;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Terminated By")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User terminatedByUser;
    @Widget(title="Current invoice period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoicePeriod currentInvoicePeriod;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Current version")
    @NotNull
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ContractVersion currentContractVersion;
    @Widget(title="Next version")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ContractVersion nextVersion;
    @Widget(title="Next Invoice Additional Benefit")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ContractLine> additionalBenefitContractLineList;
    @Widget(title="Invoice period history")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<InvoicePeriod> historyInvoicePeriodList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="contractHistory", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="createdOn DESC")
    private List<ContractVersion> versionHistory;
    @Widget(title="Consumption for next invoice")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ConsumptionLine> consumptionLineList;
    @Widget(title="Batches")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Contract() {
    }

    public Contract(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getTargetTypeSelect() {
        return this.targetTypeSelect == null ? 0 : this.targetTypeSelect;
    }

    public void setTargetTypeSelect(Integer targetTypeSelect) {
        this.targetTypeSelect = targetTypeSelect;
    }

    public Integer getPeriodNumber() {
        return this.periodNumber == null ? 0 : this.periodNumber;
    }

    public void setPeriodNumber(Integer periodNumber) {
        this.periodNumber = periodNumber;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getRenewalNumber() {
        return this.renewalNumber == null ? 0 : this.renewalNumber;
    }

    public void setRenewalNumber(Integer renewalNumber) {
        this.renewalNumber = renewalNumber;
    }

    public Integer getVersionNumber() {
        return this.versionNumber == null ? 0 : this.versionNumber;
    }

    public void setVersionNumber(Integer versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getContractId() {
        return this.contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public Boolean getIsInvoicingManagement() {
        return this.isInvoicingManagement == null ? Boolean.FALSE : this.isInvoicingManagement;
    }

    public void setIsInvoicingManagement(Boolean isInvoicingManagement) {
        this.isInvoicingManagement = isInvoicingManagement;
    }

    public Boolean getIsConsumptionManagement() {
        return this.isConsumptionManagement == null ? Boolean.FALSE : this.isConsumptionManagement;
    }

    public void setIsConsumptionManagement(Boolean isConsumptionManagement) {
        this.isConsumptionManagement = isConsumptionManagement;
    }

    public Boolean getIsAdditionaBenefitManagement() {
        return this.isAdditionaBenefitManagement == null ? Boolean.FALSE : this.isAdditionaBenefitManagement;
    }

    public void setIsAdditionaBenefitManagement(Boolean isAdditionaBenefitManagement) {
        this.isAdditionaBenefitManagement = isAdditionaBenefitManagement;
    }

    public Boolean getToClosed() {
        return this.toClosed == null ? Boolean.FALSE : this.toClosed;
    }

    public void setToClosed(Boolean toClosed) {
        this.toClosed = toClosed;
    }

    public Boolean getTerminatedManually() {
        return this.terminatedManually == null ? Boolean.FALSE : this.terminatedManually;
    }

    public void setTerminatedManually(Boolean terminatedManually) {
        this.terminatedManually = terminatedManually;
    }

    public LocalDate getFirstPeriodEndDate() {
        return this.firstPeriodEndDate;
    }

    public void setFirstPeriodEndDate(LocalDate firstPeriodEndDate) {
        this.firstPeriodEndDate = firstPeriodEndDate;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalDate getTerminatedDate() {
        return this.terminatedDate;
    }

    public void setTerminatedDate(LocalDate terminatedDate) {
        this.terminatedDate = terminatedDate;
    }

    public LocalDate getEngagementStartDate() {
        return this.engagementStartDate;
    }

    public void setEngagementStartDate(LocalDate engagementStartDate) {
        this.engagementStartDate = engagementStartDate;
    }

    public LocalDate getTerminationDemandDate() {
        return this.terminationDemandDate;
    }

    public void setTerminationDemandDate(LocalDate terminationDemandDate) {
        this.terminationDemandDate = terminationDemandDate;
    }

    public LocalDate getLastRenewalDate() {
        return this.lastRenewalDate;
    }

    public void setLastRenewalDate(LocalDate lastRenewalDate) {
        this.lastRenewalDate = lastRenewalDate;
    }

    public LocalDate getInvoicePeriodStartDate() {
        return this.invoicePeriodStartDate;
    }

    public void setInvoicePeriodStartDate(LocalDate invoicePeriodStartDate) {
        this.invoicePeriodStartDate = invoicePeriodStartDate;
    }

    public LocalDate getInvoicePeriodEndDate() {
        return this.invoicePeriodEndDate;
    }

    public void setInvoicePeriodEndDate(LocalDate invoicePeriodEndDate) {
        this.invoicePeriodEndDate = invoicePeriodEndDate;
    }

    public LocalDate getInvoicingDate() {
        return this.invoicingDate;
    }

    public void setInvoicingDate(LocalDate invoicingDate) {
        this.invoicingDate = invoicingDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public User getTerminatedByUser() {
        return this.terminatedByUser;
    }

    public void setTerminatedByUser(User terminatedByUser) {
        this.terminatedByUser = terminatedByUser;
    }

    public InvoicePeriod getCurrentInvoicePeriod() {
        return this.currentInvoicePeriod;
    }

    public void setCurrentInvoicePeriod(InvoicePeriod currentInvoicePeriod) {
        this.currentInvoicePeriod = currentInvoicePeriod;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public ContractVersion getCurrentContractVersion() {
        return this.currentContractVersion;
    }

    public void setCurrentContractVersion(ContractVersion currentContractVersion) {
        this.currentContractVersion = currentContractVersion;
    }

    public ContractVersion getNextVersion() {
        return this.nextVersion;
    }

    public void setNextVersion(ContractVersion nextVersion) {
        this.nextVersion = nextVersion;
    }

    public List<ContractLine> getAdditionalBenefitContractLineList() {
        return this.additionalBenefitContractLineList;
    }

    public void setAdditionalBenefitContractLineList(List<ContractLine> additionalBenefitContractLineList) {
        this.additionalBenefitContractLineList = additionalBenefitContractLineList;
    }

    public void addAdditionalBenefitContractLineListItem(ContractLine item) {
        if (this.getAdditionalBenefitContractLineList() == null) {
            this.setAdditionalBenefitContractLineList(new ArrayList<ContractLine>());
        }
        this.getAdditionalBenefitContractLineList().add(item);
    }

    public void removeAdditionalBenefitContractLineListItem(ContractLine item) {
        if (this.getAdditionalBenefitContractLineList() == null) {
            return;
        }
        this.getAdditionalBenefitContractLineList().remove(item);
    }

    public void clearAdditionalBenefitContractLineList() {
        if (this.getAdditionalBenefitContractLineList() != null) {
            this.getAdditionalBenefitContractLineList().clear();
        }
    }

    public List<InvoicePeriod> getHistoryInvoicePeriodList() {
        return this.historyInvoicePeriodList;
    }

    public void setHistoryInvoicePeriodList(List<InvoicePeriod> historyInvoicePeriodList) {
        this.historyInvoicePeriodList = historyInvoicePeriodList;
    }

    public void addHistoryInvoicePeriodListItem(InvoicePeriod item) {
        if (this.getHistoryInvoicePeriodList() == null) {
            this.setHistoryInvoicePeriodList(new ArrayList<InvoicePeriod>());
        }
        this.getHistoryInvoicePeriodList().add(item);
    }

    public void removeHistoryInvoicePeriodListItem(InvoicePeriod item) {
        if (this.getHistoryInvoicePeriodList() == null) {
            return;
        }
        this.getHistoryInvoicePeriodList().remove(item);
    }

    public void clearHistoryInvoicePeriodList() {
        if (this.getHistoryInvoicePeriodList() != null) {
            this.getHistoryInvoicePeriodList().clear();
        }
    }

    public List<ContractVersion> getVersionHistory() {
        return this.versionHistory;
    }

    public void setVersionHistory(List<ContractVersion> versionHistory) {
        this.versionHistory = versionHistory;
    }

    public void addVersionHistory(ContractVersion item) {
        if (this.getVersionHistory() == null) {
            this.setVersionHistory(new ArrayList<ContractVersion>());
        }
        this.getVersionHistory().add(item);
        item.setContractHistory(this);
    }

    public void removeVersionHistory(ContractVersion item) {
        if (this.getVersionHistory() == null) {
            return;
        }
        this.getVersionHistory().remove(item);
    }

    public void clearVersionHistory() {
        if (this.getVersionHistory() != null) {
            this.getVersionHistory().clear();
        }
    }

    public List<ConsumptionLine> getConsumptionLineList() {
        return this.consumptionLineList;
    }

    public void setConsumptionLineList(List<ConsumptionLine> consumptionLineList) {
        this.consumptionLineList = consumptionLineList;
    }

    public void addConsumptionLineListItem(ConsumptionLine item) {
        if (this.getConsumptionLineList() == null) {
            this.setConsumptionLineList(new ArrayList<ConsumptionLine>());
        }
        this.getConsumptionLineList().add(item);
    }

    public void removeConsumptionLineListItem(ConsumptionLine item) {
        if (this.getConsumptionLineList() == null) {
            return;
        }
        this.getConsumptionLineList().remove(item);
    }

    public void clearConsumptionLineList() {
        if (this.getConsumptionLineList() != null) {
            this.getConsumptionLineList().clear();
        }
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Contract)) {
            return false;
        }
        Contract other = (Contract)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("targetTypeSelect", (Object)this.getTargetTypeSelect()).add("periodNumber", (Object)this.getPeriodNumber()).add("statusSelect", (Object)this.getStatusSelect()).add("renewalNumber", (Object)this.getRenewalNumber()).add("versionNumber", (Object)this.getVersionNumber()).add("name", (Object)this.getName()).add("contractId", (Object)this.getContractId()).add("isInvoicingManagement", (Object)this.getIsInvoicingManagement()).add("isConsumptionManagement", (Object)this.getIsConsumptionManagement()).add("isAdditionaBenefitManagement", (Object)this.getIsAdditionaBenefitManagement()).add("toClosed", (Object)this.getToClosed()).omitNullValues().toString();
    }
}

