/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.quality.db.ControlPointType;
import com.axelor.apps.quality.db.QualityMeasuringPoint;
import com.axelor.apps.quality.db.QualityProcess;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="QUALITY_CONTROL_POINT_MODEL", indexes={@Index(columnList="name"), @Index(columnList="quality_process"), @Index(columnList="optional_quality_process"), @Index(columnList="control_point_type")})
public class ControlPointModel
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_CONTROL_POINT_MODEL_SEQ")
    @SequenceGenerator(name="QUALITY_CONTROL_POINT_MODEL_SEQ", sequenceName="QUALITY_CONTROL_POINT_MODEL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Control point name")
    @NotNull
    private String name;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Control Frequency")
    private BigDecimal controlFrequency = BigDecimal.ZERO;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String notes;
    @Widget(title="counter")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private QualityProcess qualityProcess;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private QualityProcess optionalQualityProcess;
    @Widget(title="Measuring point list")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<QualityMeasuringPoint> measuringPointList;
    @Widget(title="Type")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ControlPointType controlPointType;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ControlPointModel() {
    }

    public ControlPointModel(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public BigDecimal getControlFrequency() {
        return this.controlFrequency == null ? BigDecimal.ZERO : this.controlFrequency;
    }

    public void setControlFrequency(BigDecimal controlFrequency) {
        this.controlFrequency = controlFrequency;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public QualityProcess getQualityProcess() {
        return this.qualityProcess;
    }

    public void setQualityProcess(QualityProcess qualityProcess) {
        this.qualityProcess = qualityProcess;
    }

    public QualityProcess getOptionalQualityProcess() {
        return this.optionalQualityProcess;
    }

    public void setOptionalQualityProcess(QualityProcess optionalQualityProcess) {
        this.optionalQualityProcess = optionalQualityProcess;
    }

    public List<QualityMeasuringPoint> getMeasuringPointList() {
        return this.measuringPointList;
    }

    public void setMeasuringPointList(List<QualityMeasuringPoint> measuringPointList) {
        this.measuringPointList = measuringPointList;
    }

    public void addMeasuringPointListItem(QualityMeasuringPoint item) {
        if (this.getMeasuringPointList() == null) {
            this.setMeasuringPointList(new ArrayList<QualityMeasuringPoint>());
        }
        this.getMeasuringPointList().add(item);
    }

    public void removeMeasuringPointListItem(QualityMeasuringPoint item) {
        if (this.getMeasuringPointList() == null) {
            return;
        }
        this.getMeasuringPointList().remove((Object)item);
    }

    public void clearMeasuringPointList() {
        if (this.getMeasuringPointList() != null) {
            this.getMeasuringPointList().clear();
        }
    }

    public ControlPointType getControlPointType() {
        return this.controlPointType;
    }

    public void setControlPointType(ControlPointType controlPointType) {
        this.controlPointType = controlPointType;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ControlPointModel)) {
            return false;
        }
        ControlPointModel other = (ControlPointModel)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("sequence", (Object)this.getSequence()).add("controlFrequency", (Object)this.getControlFrequency()).omitNullValues().toString();
    }
}

