/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.quality.db.QualityControl;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="QUALITY_QUALITY_CORRECTIVE_ACTION", indexes={@Index(columnList="name"), @Index(columnList="quality_control")})
public class QualityCorrectiveAction
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_QUALITY_CORRECTIVE_ACTION_SEQ")
    @SequenceGenerator(name="QUALITY_QUALITY_CORRECTIVE_ACTION_SEQ", sequenceName="QUALITY_QUALITY_CORRECTIVE_ACTION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Applicable")
    private Boolean isApplicable = Boolean.FALSE;
    @Widget(title="Details")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String details;
    @Widget(title="Quality control")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private QualityControl qualityControl;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public QualityCorrectiveAction() {
    }

    public QualityCorrectiveAction(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsApplicable() {
        return this.isApplicable == null ? Boolean.FALSE : this.isApplicable;
    }

    public void setIsApplicable(Boolean isApplicable) {
        this.isApplicable = isApplicable;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public QualityControl getQualityControl() {
        return this.qualityControl;
    }

    public void setQualityControl(QualityControl qualityControl) {
        this.qualityControl = qualityControl;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualityCorrectiveAction)) {
            return false;
        }
        QualityCorrectiveAction other = (QualityCorrectiveAction)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("isApplicable", (Object)this.getIsApplicable()).omitNullValues().toString();
    }
}

