/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.db;

import com.axelor.apps.quality.db.ControlPoint;
import com.axelor.apps.quality.db.QualityPictures;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="QUALITY_QUALITY_MEASURING_POINT", indexes={@Index(columnList="name"), @Index(columnList="control_point")})
public class QualityMeasuringPoint
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="QUALITY_QUALITY_MEASURING_POINT_SEQ")
    @SequenceGenerator(name="QUALITY_QUALITY_MEASURING_POINT_SEQ", sequenceName="QUALITY_QUALITY_MEASURING_POINT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Note", selection="quality.measuring.point.measuring.note.select")
    private Integer measuringNote = 0;
    @Widget(title="Compliant")
    private Boolean compliant = Boolean.FALSE;
    @Widget(title="Coefficient")
    private BigDecimal coefficient = BigDecimal.ZERO;
    @Widget(title="Observations")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String observations;
    @Widget(title="Pictures")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="qualityMeasuringPoint", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<QualityPictures> picturesList;
    @Widget(title="Measuring Type", selection="quality.measuring.point.measuring.type.select")
    private Integer measuringTypeSelect = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ControlPoint controlPoint;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public QualityMeasuringPoint() {
    }

    public QualityMeasuringPoint(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMeasuringNote() {
        return this.measuringNote == null ? 0 : this.measuringNote;
    }

    public void setMeasuringNote(Integer measuringNote) {
        this.measuringNote = measuringNote;
    }

    public Boolean getCompliant() {
        return this.compliant == null ? Boolean.FALSE : this.compliant;
    }

    public void setCompliant(Boolean compliant) {
        this.compliant = compliant;
    }

    public BigDecimal getCoefficient() {
        return this.coefficient == null ? BigDecimal.ZERO : this.coefficient;
    }

    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    public String getObservations() {
        return this.observations;
    }

    public void setObservations(String observations) {
        this.observations = observations;
    }

    public List<QualityPictures> getPicturesList() {
        return this.picturesList;
    }

    public void setPicturesList(List<QualityPictures> picturesList) {
        this.picturesList = picturesList;
    }

    public void addPicturesListItem(QualityPictures item) {
        if (this.getPicturesList() == null) {
            this.setPicturesList(new ArrayList<QualityPictures>());
        }
        this.getPicturesList().add(item);
        item.setQualityMeasuringPoint(this);
    }

    public void removePicturesListItem(QualityPictures item) {
        if (this.getPicturesList() == null) {
            return;
        }
        this.getPicturesList().remove((Object)item);
    }

    public void clearPicturesList() {
        if (this.getPicturesList() != null) {
            this.getPicturesList().clear();
        }
    }

    public Integer getMeasuringTypeSelect() {
        return this.measuringTypeSelect == null ? 0 : this.measuringTypeSelect;
    }

    public void setMeasuringTypeSelect(Integer measuringTypeSelect) {
        this.measuringTypeSelect = measuringTypeSelect;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public void setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QualityMeasuringPoint)) {
            return false;
        }
        QualityMeasuringPoint other = (QualityMeasuringPoint)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("measuringNote", (Object)this.getMeasuringNote()).add("compliant", (Object)this.getCompliant()).add("coefficient", (Object)this.getCoefficient()).add("measuringTypeSelect", (Object)this.getMeasuringTypeSelect()).omitNullValues().toString();
    }
}

