/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.service.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.quality.db.QualityControl;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.io.File;

public class QualityControlPrintServiceImpl {
    public String getFileName(QualityControl qualityControl) {
        return I18n.get((String)"QualityControl") + " " + qualityControl.getReference();
    }

    public String printQualityControl(QualityControl qualityControl, String format) throws AxelorException {
        String fileName = I18n.get((String)"QualityControl") + " - " + qualityControl.getSequence() + "." + format;
        return PdfTool.getFileLinkFromPdfFile((File)this.print(qualityControl, format), (String)fileName);
    }

    public File print(QualityControl qualityControl, String format) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(qualityControl, format);
        return reportSettings.generate().getFile();
    }

    public ReportSettings prepareReportSettings(QualityControl qualityControl, String format) throws AxelorException {
        if (qualityControl.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on quality control"), new Object[0]), new Object[]{qualityControl});
        }
        String locale = ReportSettings.getPrintingLocale((Partner)qualityControl.getProject().getClientPartner());
        String title = this.getFileName(qualityControl);
        ReportSettings reportSetting = ReportFactory.createReport((String)"QualityControl.rptdesign", (String)(title + " - ${date}"));
        return reportSetting.addParam("QualityControlId", (Object)qualityControl.getId()).addParam("Timezone", (Object)this.getTimezone(qualityControl)).addParam("Locale", (Object)locale).addFormat(format);
    }

    private String getTimezone(QualityControl qualityControl) {
        if (qualityControl.getProject() == null || qualityControl.getProject().getCompany() == null) {
            return null;
        }
        return qualityControl.getProject().getCompany().getTimezone();
    }
}

