/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.quality.web;

import com.axelor.apps.quality.db.ControlPoint;
import com.axelor.apps.quality.db.QualityControl;
import com.axelor.apps.quality.db.QualityProcess;
import com.axelor.apps.quality.db.repo.ControlPointRepository;
import com.axelor.apps.quality.db.repo.QualityControlRepository;
import com.axelor.apps.quality.db.repo.QualityProcessRepository;
import com.axelor.apps.quality.service.QualityControlService;
import com.axelor.apps.quality.service.print.QualityControlPrintServiceImpl;
import com.axelor.common.ObjectUtils;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Singleton
public class QualityControlController {
    public void openControlPoints(ActionRequest request, ActionResponse response) {
        response.setView(ActionView.define((String)I18n.get((String)"Control points")).model("com.axelor.apps.quality.db.ControlPoint").add("grid", "control-point-grid").add("form", "control-point-form").domain("self.qualityControl.id = " + ((QualityControl)((Object)request.getContext().asType(QualityControl.class))).getId()).map());
    }

    public void preFillOperations(ActionRequest request, ActionResponse response) throws AxelorException {
        LinkedHashMap qualityProcessMap = (LinkedHashMap)request.getContext().get((Object)"qualityProcess");
        LinkedHashMap qualityControlMap = (LinkedHashMap)request.getContext().get((Object)"_qualityControl");
        QualityProcess qualityProcess = (QualityProcess)((Object)((QualityProcessRepository)((Object)Beans.get(QualityProcessRepository.class))).find(((Integer)qualityProcessMap.get("id")).longValue()));
        QualityControl qualityControl = (QualityControl)((Object)((QualityControlRepository)((Object)Beans.get(QualityControlRepository.class))).find(((Integer)qualityControlMap.get("id")).longValue()));
        ((QualityControlService)Beans.get(QualityControlService.class)).preFillOperations(qualityControl, qualityProcess);
        response.setCanClose(true);
    }

    public void preFillOperationsFromOptionals(ActionRequest request, ActionResponse response) {
        HashSet optionalControlPoints = new HashSet();
        ArrayList<ControlPoint> optionalControlPointList = new ArrayList<ControlPoint>();
        Collection optionalControlPointSet = (Collection)request.getContext().get((Object)"optionalControlPointSet");
        if (optionalControlPointSet != null) {
            optionalControlPoints.addAll(optionalControlPointSet);
        }
        for (Map optionalControlPointData : optionalControlPoints) {
            ControlPoint optionalControlPoint = (ControlPoint)((Object)((ControlPointRepository)((Object)Beans.get(ControlPointRepository.class))).find(Long.parseLong(optionalControlPointData.get("id").toString())));
            optionalControlPointList.add(optionalControlPoint);
        }
        LinkedHashMap qualityControlMap = (LinkedHashMap)request.getContext().get((Object)"_qualityControl");
        QualityControl qualityControl = (QualityControl)((Object)((QualityControlRepository)((Object)Beans.get(QualityControlRepository.class))).find(((Integer)qualityControlMap.get("id")).longValue()));
        ((QualityControlService)Beans.get(QualityControlService.class)).preFillOperationsFromOptionals(qualityControl, optionalControlPointList);
        response.setCanClose(true);
    }

    public void printQualityControl(ActionRequest request, ActionResponse response) throws AxelorException {
        QualityControl qualityControl = (QualityControl)((Object)request.getContext().asType(QualityControl.class));
        qualityControl = (QualityControl)((Object)((QualityControlRepository)((Object)Beans.get(QualityControlRepository.class))).find(qualityControl.getId()));
        String title = ((QualityControlPrintServiceImpl)Beans.get(QualityControlPrintServiceImpl.class)).getFileName(qualityControl);
        String fileLink = ((QualityControlPrintServiceImpl)Beans.get(QualityControlPrintServiceImpl.class)).printQualityControl(qualityControl, "pdf");
        response.setView(ActionView.define((String)title).add("html", fileLink).map());
    }

    public void sendEmail(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            QualityControlService qualityControlService = (QualityControlService)Beans.get(QualityControlService.class);
            if (!ObjectUtils.isEmpty((Object)context.get((Object)"_ids"))) {
                List idList = Lists.transform((List)((List)context.get((Object)"_ids")), (Function)new Function<Object, Long>(){

                    @Nullable
                    public Long apply(@Nullable Object input) {
                        return Long.parseLong(input.toString());
                    }
                });
                QualityControlRepository qualityControlRepo = (QualityControlRepository)((Object)Beans.get(QualityControlRepository.class));
                for (Long id : idList) {
                    QualityControl qualityControl = (QualityControl)((Object)qualityControlRepo.find(id));
                    if (qualityControl.getStatusSelect() != 6) continue;
                    qualityControlService.sendEmail(qualityControl);
                }
            } else if (!ObjectUtils.isEmpty((Object)context.get((Object)"id"))) {
                QualityControl qualityControl = (QualityControl)((Object)context.asType(QualityControl.class));
                qualityControlService.sendEmail(qualityControl);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

