/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountEquiv;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_FISCAL_POSITION", indexes={@Index(columnList="name"), @Index(columnList="code")})
public class FiscalPosition
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_FISCAL_POSITION_SEQ")
    @SequenceGenerator(name="ACCOUNT_FISCAL_POSITION_SEQ", sequenceName="ACCOUNT_FISCAL_POSITION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Tax equivalences")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fiscalPosition", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TaxEquiv> taxEquivList;
    @Widget(title="Account equivalences")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="fiscalPosition", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AccountEquiv> accountEquivList;
    @Widget(title="Customer specific note")
    private Boolean customerSpecificNote = Boolean.FALSE;
    @Widget(title="Customer specific note")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String customerSpecificNoteText;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public FiscalPosition() {
    }

    public FiscalPosition(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<TaxEquiv> getTaxEquivList() {
        return this.taxEquivList;
    }

    public void setTaxEquivList(List<TaxEquiv> taxEquivList) {
        this.taxEquivList = taxEquivList;
    }

    public void addTaxEquivListItem(TaxEquiv item) {
        if (this.getTaxEquivList() == null) {
            this.setTaxEquivList(new ArrayList<TaxEquiv>());
        }
        this.getTaxEquivList().add(item);
        item.setFiscalPosition(this);
    }

    public void removeTaxEquivListItem(TaxEquiv item) {
        if (this.getTaxEquivList() == null) {
            return;
        }
        this.getTaxEquivList().remove(item);
    }

    public void clearTaxEquivList() {
        if (this.getTaxEquivList() != null) {
            this.getTaxEquivList().clear();
        }
    }

    public List<AccountEquiv> getAccountEquivList() {
        return this.accountEquivList;
    }

    public void setAccountEquivList(List<AccountEquiv> accountEquivList) {
        this.accountEquivList = accountEquivList;
    }

    public void addAccountEquivListItem(AccountEquiv item) {
        if (this.getAccountEquivList() == null) {
            this.setAccountEquivList(new ArrayList<AccountEquiv>());
        }
        this.getAccountEquivList().add(item);
        item.setFiscalPosition(this);
    }

    public void removeAccountEquivListItem(AccountEquiv item) {
        if (this.getAccountEquivList() == null) {
            return;
        }
        this.getAccountEquivList().remove(item);
    }

    public void clearAccountEquivList() {
        if (this.getAccountEquivList() != null) {
            this.getAccountEquivList().clear();
        }
    }

    public Boolean getCustomerSpecificNote() {
        return this.customerSpecificNote == null ? Boolean.FALSE : this.customerSpecificNote;
    }

    public void setCustomerSpecificNote(Boolean customerSpecificNote) {
        this.customerSpecificNote = customerSpecificNote;
    }

    public String getCustomerSpecificNoteText() {
        return this.customerSpecificNoteText;
    }

    public void setCustomerSpecificNoteText(String customerSpecificNoteText) {
        this.customerSpecificNoteText = customerSpecificNoteText;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FiscalPosition)) {
            return false;
        }
        FiscalPosition other = (FiscalPosition)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("customerSpecificNote", (Object)this.getCustomerSpecificNote()).omitNullValues().toString();
    }
}

