/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db;

import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="CONTRACT_CONSUMPTION_LINE", indexes={@Index(columnList="product"), @Index(columnList="unit"), @Index(columnList="contract_line"), @Index(columnList="invoice_line"), @Index(columnList="fullName")})
public class ConsumptionLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTRACT_CONSUMPTION_LINE_SEQ")
    @SequenceGenerator(name="CONTRACT_CONSUMPTION_LINE_SEQ", sequenceName="CONTRACT_CONSUMPTION_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Quantity")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Date")
    private LocalDate lineDate;
    @Widget(title="Invoiced")
    private Boolean isInvoiced = Boolean.FALSE;
    @Widget(title="Error")
    private Boolean isError = Boolean.FALSE;
    @Widget(title="Reference")
    private String reference;
    @Widget(title="Contract line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ContractLine contractLine;
    @Widget(title="Invoice line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceLine invoiceLine;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public LocalDate getLineDate() {
        return this.lineDate;
    }

    public void setLineDate(LocalDate lineDate) {
        this.lineDate = lineDate;
    }

    public Boolean getIsInvoiced() {
        return this.isInvoiced == null ? Boolean.FALSE : this.isInvoiced;
    }

    public void setIsInvoiced(Boolean isInvoiced) {
        this.isInvoiced = isInvoiced;
    }

    public Boolean getIsError() {
        return this.isError == null ? Boolean.FALSE : this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public ContractLine getContractLine() {
        return this.contractLine;
    }

    public void setContractLine(ContractLine contractLine) {
        this.contractLine = contractLine;
    }

    public InvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(InvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.product != null && this.product.getName() != null) {
            fullName = fullName + this.product.getName();
            if (this.reference != null) {
                fullName = fullName + " - " + this.reference;
            }
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConsumptionLine)) {
            return false;
        }
        ConsumptionLine other = (ConsumptionLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("qty", (Object)this.getQty()).add("lineDate", (Object)this.getLineDate()).add("isInvoiced", (Object)this.getIsInvoiced()).add("isError", (Object)this.getIsError()).add("reference", (Object)this.getReference()).omitNullValues().toString();
    }
}

