/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.contract.db.ConsumptionLine;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="CONTRACT_INVOICE_PERIOD", indexes={@Index(columnList="fullName"), @Index(columnList="invoice"), @Index(columnList="contract")})
public class InvoicePeriod
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTRACT_INVOICE_PERIOD_SEQ")
    @SequenceGenerator(name="CONTRACT_INVOICE_PERIOD_SEQ", sequenceName="CONTRACT_INVOICE_PERIOD_SEQ", allocationSize=1)
    private Long id;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Statut", readonly=true, selection="contract.invoice.period.statut.select")
    private Integer statusSelect = 1;
    @Widget(title="Last Invoicing period", readonly=true)
    private Boolean isLastPeriod = Boolean.FALSE;
    @Widget(title="Start date", readonly=true)
    private LocalDate startDate;
    @Widget(title="End date", readonly=true)
    private LocalDate endDate;
    @Widget(title="Consumptions")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ConsumptionLine> consumptionLineList;
    @Widget(title="Additional benefit")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ContractLine> additionalBenefitList;
    @Widget(title="Linked invoice", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Invoice invoice;
    @Widget(title="Contract")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Contract contract;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullname = "";
        if (this.startDate != null && this.endDate != null) {
            fullname = this.startDate.toString() + " - " + this.endDate.toString();
        }
        return fullname;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsLastPeriod() {
        return this.isLastPeriod == null ? Boolean.FALSE : this.isLastPeriod;
    }

    public void setIsLastPeriod(Boolean isLastPeriod) {
        this.isLastPeriod = isLastPeriod;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public List<ConsumptionLine> getConsumptionLineList() {
        return this.consumptionLineList;
    }

    public void setConsumptionLineList(List<ConsumptionLine> consumptionLineList) {
        this.consumptionLineList = consumptionLineList;
    }

    public void addConsumptionLineListItem(ConsumptionLine item) {
        if (this.getConsumptionLineList() == null) {
            this.setConsumptionLineList(new ArrayList<ConsumptionLine>());
        }
        this.getConsumptionLineList().add(item);
    }

    public void removeConsumptionLineListItem(ConsumptionLine item) {
        if (this.getConsumptionLineList() == null) {
            return;
        }
        this.getConsumptionLineList().remove((Object)item);
    }

    public void clearConsumptionLineList() {
        if (this.getConsumptionLineList() != null) {
            this.getConsumptionLineList().clear();
        }
    }

    public List<ContractLine> getAdditionalBenefitList() {
        return this.additionalBenefitList;
    }

    public void setAdditionalBenefitList(List<ContractLine> additionalBenefitList) {
        this.additionalBenefitList = additionalBenefitList;
    }

    public void addAdditionalBenefitListItem(ContractLine item) {
        if (this.getAdditionalBenefitList() == null) {
            this.setAdditionalBenefitList(new ArrayList<ContractLine>());
        }
        this.getAdditionalBenefitList().add(item);
    }

    public void removeAdditionalBenefitListItem(ContractLine item) {
        if (this.getAdditionalBenefitList() == null) {
            return;
        }
        this.getAdditionalBenefitList().remove((Object)item);
    }

    public void clearAdditionalBenefitList() {
        if (this.getAdditionalBenefitList() != null) {
            this.getAdditionalBenefitList().clear();
        }
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvoicePeriod)) {
            return false;
        }
        InvoicePeriod other = (InvoicePeriod)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("isLastPeriod", (Object)this.getIsLastPeriod()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).omitNullValues().toString();
    }
}

