/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.generator;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;

public class InvoiceGeneratorContract
extends InvoiceGenerator {
    protected Contract contract;
    private AppBaseService appBaseService;

    public InvoiceGeneratorContract(Contract contract) throws AxelorException {
        super(contract.getTargetTypeSelect() == 1 ? 3 : 1, contract.getCompany(), contract.getPartner(), null, null, contract.getContractId(), null, null, null);
        this.contract = contract;
        this.currency = contract.getCurrency();
        this.paymentCondition = contract.getCurrentContractVersion().getPaymentCondition();
        this.paymentMode = contract.getCurrentContractVersion().getPaymentMode();
        this.appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
    }

    protected Invoice createInvoiceHeader() throws AxelorException {
        Invoice invoice = super.createInvoiceHeader();
        ContractVersion version = this.contract.getCurrentContractVersion();
        if (this.contract.getIsInvoicingManagement().booleanValue() && version.getIsPeriodicInvoicing().booleanValue()) {
            invoice.setOperationSubTypeSelect(7);
            invoice.setSubscriptionFromDate(this.contract.getInvoicePeriodStartDate());
            invoice.setSubscriptionToDate(this.contract.getInvoicePeriodEndDate());
        } else if (this.contract.getEndDate() == null || this.contract.getEndDate().isAfter(this.appBaseService.getTodayDate(this.company))) {
            invoice.setOperationSubTypeSelect(4);
        } else {
            invoice.setOperationSubTypeSelect(5);
        }
        invoice.setContract(this.contract);
        if (this.contract.getInvoicingDate() != null) {
            invoice.setInvoiceDate(this.contract.getInvoicingDate());
        } else {
            invoice.setInvoiceDate(this.appBaseService.getTodayDate(this.company));
        }
        invoice.setBankDetails(this.contract.getPartner().getBankDetailsList().stream().filter(it -> it.getIsDefault()).findFirst().orElse(null));
        return invoice;
    }

    public Invoice generate() throws AxelorException {
        return this.createInvoiceHeader();
    }
}

