/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class ContractLineServiceImpl
implements ContractLineService {
    protected AppBaseService appBaseService;
    protected AccountManagementService accountManagementService;
    protected CurrencyService currencyService;
    protected ProductCompanyService productCompanyService;

    @Inject
    public ContractLineServiceImpl(AppBaseService appBaseService, AccountManagementService accountManagementService, CurrencyService currencyService, ProductCompanyService productCompanyService) {
        this.appBaseService = appBaseService;
        this.accountManagementService = accountManagementService;
        this.currencyService = currencyService;
        this.productCompanyService = productCompanyService;
    }

    @Override
    public ContractLine reset(ContractLine contractLine) {
        if (contractLine == null) {
            return new ContractLine();
        }
        contractLine.setTaxLine(null);
        contractLine.setProductName(null);
        contractLine.setUnit(null);
        contractLine.setPrice(null);
        contractLine.setExTaxTotal(null);
        contractLine.setInTaxTotal(null);
        contractLine.setDescription(null);
        return contractLine;
    }

    @Override
    public ContractLine fill(ContractLine contractLine, Product product) throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)product), (Object)I18n.get((String)"The product can't be empty."));
        Company company = contractLine.getContractVersion() != null ? (contractLine.getContractVersion().getContract() != null ? contractLine.getContractVersion().getContract().getCompany() : null) : null;
        contractLine.setProductName((String)this.productCompanyService.get(product, "name", company));
        Unit unit = (Unit)this.productCompanyService.get(product, "salesUnit", company);
        if (unit != null) {
            contractLine.setUnit(unit);
        } else {
            contractLine.setUnit((Unit)this.productCompanyService.get(product, "unit", company));
        }
        contractLine.setPrice((BigDecimal)this.productCompanyService.get(product, "salePrice", company));
        contractLine.setDescription((String)this.productCompanyService.get(product, "description", company));
        return contractLine;
    }

    @Override
    public ContractLine compute(ContractLine contractLine, Contract contract, Product product) throws AxelorException {
        BigDecimal price;
        Preconditions.checkNotNull((Object)((Object)contract), (Object)I18n.get((String)"Contract can't be empty for compute contract line price."));
        Preconditions.checkNotNull((Object)((Object)product), (Object)"Product can't be empty for compute contract line price.");
        contractLine.setFiscalPosition(contract.getPartner().getFiscalPosition());
        TaxLine taxLine = this.accountManagementService.getTaxLine(this.appBaseService.getTodayDate(contract.getCompany()), product, contract.getCompany(), contractLine.getFiscalPosition(), false);
        contractLine.setTaxLine(taxLine);
        if (taxLine != null && ((Boolean)this.productCompanyService.get(product, "inAti", contract.getCompany())).booleanValue()) {
            price = contractLine.getPrice();
            price = price.divide(taxLine.getValue().add(BigDecimal.ONE), 2, 4);
            contractLine.setPrice(price);
        }
        price = contractLine.getPrice();
        BigDecimal convert = this.currencyService.getCurrencyConversionRate((Currency)this.productCompanyService.get(product, "saleCurrency", contract.getCompany()), contract.getCurrency(), this.appBaseService.getTodayDate(contract.getCompany()));
        contractLine.setPrice(price.multiply(convert));
        return contractLine;
    }

    @Override
    public ContractLine fillAndCompute(ContractLine contractLine, Contract contract, Product product) throws AxelorException {
        contractLine = this.fill(contractLine, product);
        contractLine = this.compute(contractLine, contract, product);
        return contractLine;
    }

    @Override
    public ContractLine computeTotal(ContractLine contractLine) {
        BigDecimal taxRate = BigDecimal.ZERO;
        if (contractLine.getTaxLine() != null) {
            taxRate = contractLine.getTaxLine().getValue();
        }
        BigDecimal exTaxTotal = contractLine.getQty().multiply(contractLine.getPrice()).setScale(2, RoundingMode.HALF_EVEN);
        contractLine.setExTaxTotal(exTaxTotal);
        BigDecimal inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
        contractLine.setInTaxTotal(inTaxTotal);
        return contractLine;
    }

    @Override
    public ContractLine createAnalyticDistributionWithTemplate(ContractLine contractLine, Contract contract) {
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        List analyticMoveLineList = ((AnalyticMoveLineService)Beans.get(AnalyticMoveLineService.class)).generateLines(contractLine.getAnalyticDistributionTemplate(), contractLine.getExTaxTotal(), 4, appAccountService.getTodayDate(contract.getCompany()));
        contractLine.setAnalyticMoveLineList(analyticMoveLineList);
        return contractLine;
    }
}

