/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.service;

import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;

public interface ContractVersionService {
    @Transactional(rollbackOn={Exception.class})
    public void waiting(ContractVersion var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void waiting(ContractVersion var1, LocalDate var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void ongoing(ContractVersion var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void ongoing(ContractVersion var1, LocalDate var2) throws AxelorException;

    @Transactional
    public void terminate(ContractVersion var1);

    @Transactional
    public void terminate(ContractVersion var1, LocalDate var2);

    public ContractVersion newDraft(Contract var1);

    default public ContractVersion getContractVersion(Contract contract, LocalDate date) {
        for (ContractVersion version : contract.getVersionHistory()) {
            if (version.getActivationDate() == null || version.getEndDate() == null || !DateTool.isBetween((LocalDate)version.getActivationDate(), (LocalDate)version.getEndDate(), (LocalDate)date)) continue;
            return version;
        }
        ContractVersion version = contract.getCurrentContractVersion();
        if (DateTool.isBetween((LocalDate)version.getActivationDate(), (LocalDate)version.getEndDate(), (LocalDate)date)) {
            return version;
        }
        return null;
    }
}

