/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.contract.db.repo.ContractVersionRepository;
import com.axelor.apps.contract.service.ContractVersionService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ContractVersionServiceImpl
extends ContractVersionRepository
implements ContractVersionService {
    protected AppBaseService appBaseService;

    @Inject
    public ContractVersionServiceImpl(AppBaseService appBaseService) {
        this.appBaseService = appBaseService;
    }

    @Override
    public void waiting(ContractVersion version) throws AxelorException {
        this.waiting(version, this.appBaseService.getTodayDate(version.getContract() != null ? version.getContract().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void waiting(ContractVersion version, LocalDate date) throws AxelorException {
        Contract contract = Stream.of(version.getContract(), version.getNextContract()).filter(Objects::nonNull).findFirst().orElseThrow(() -> new AxelorException(1, I18n.get((String)"There is no contract associated with this version.")));
        if (contract.getIsInvoicingManagement().booleanValue() && version.getIsPeriodicInvoicing().booleanValue() && (contract.getFirstPeriodEndDate() == null || version.getInvoicingDuration() == null)) {
            throw new AxelorException(4, I18n.get((String)"Please fill the first period end date and the invoice frequency."));
        }
        version.setStatusSelect(2);
    }

    @Override
    public void ongoing(ContractVersion version) throws AxelorException {
        this.ongoing(version, this.appBaseService.getTodayDate(version.getContract() != null ? version.getContract().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void ongoing(ContractVersion version, LocalDate date) throws AxelorException {
        version.setActivationDate(date);
        version.setActivatedByUser(AuthUtils.getUser());
        version.setStatusSelect(3);
        if (version.getVersion() >= 0 && version.getIsWithEngagement().booleanValue() && version.getEngagementStartFromVersion().booleanValue()) {
            Preconditions.checkNotNull((Object)((Object)version.getContract()), (Object)I18n.get((String)"No contract is associated to version."));
            version.getContract().setEngagementStartDate(date);
        }
        if (version.getContract().getIsInvoicingManagement().booleanValue() && version.getIsPeriodicInvoicing().booleanValue() && (version.getContract().getFirstPeriodEndDate() == null || version.getInvoicingDuration() == null)) {
            throw new AxelorException(4, I18n.get((String)"Please fill the first period end date and the invoice frequency."));
        }
        this.save((Model)((Object)version));
    }

    @Override
    public void terminate(ContractVersion version) {
        this.terminate(version, this.appBaseService.getTodayDate(version.getContract() != null ? version.getContract().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
    }

    @Override
    @Transactional
    public void terminate(ContractVersion version, LocalDate date) {
        version.setEndDate(date);
        version.setStatusSelect(4);
        this.save((Model)((Object)version));
    }

    @Override
    public ContractVersion newDraft(Contract contract) {
        return this.copy(contract);
    }
}

