/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.studio.db.AppBuilder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Cacheable
@Table(name="META_SELECT", indexes={@Index(columnList="name"), @Index(columnList="app_builder")})
public class MetaSelect
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="META_SELECT_SEQ")
    @SequenceGenerator(name="META_SELECT_SEQ", sequenceName="META_SELECT_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Column(unique=true)
    private String xmlId;
    @NotNull
    private String name;
    @NotNull
    private Integer priority = 20;
    private String module;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="select", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaSelectItem> items;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Custom")
    private Boolean isCustom = Boolean.FALSE;

    public MetaSelect() {
    }

    public MetaSelect(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public List<MetaSelectItem> getItems() {
        return this.items;
    }

    public void setItems(List<MetaSelectItem> items) {
        this.items = items;
    }

    public void addItem(MetaSelectItem item) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<MetaSelectItem>());
        }
        this.getItems().add(item);
        item.setSelect(this);
    }

    public void removeItem(MetaSelectItem item) {
        if (this.getItems() == null) {
            return;
        }
        this.getItems().remove(item);
    }

    public void clearItems() {
        if (this.getItems() != null) {
            this.getItems().clear();
        }
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public Boolean getIsCustom() {
        return this.isCustom == null ? Boolean.FALSE : this.isCustom;
    }

    public void setIsCustom(Boolean isCustom) {
        this.isCustom = isCustom;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetaSelect)) {
            return false;
        }
        MetaSelect other = (MetaSelect)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getXmlId(), other.getXmlId());
    }

    public int hashCode() {
        return Objects.hash(-1447052415, this.getXmlId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("xmlId", (Object)this.getXmlId()).add("name", (Object)this.getName()).add("priority", (Object)this.getPriority()).add("module", (Object)this.getModule()).add("isCustom", (Object)this.getIsCustom()).omitNullValues().toString();
    }
}

