/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModule;
import com.axelor.studio.db.ActionBuilderLine;
import com.axelor.studio.db.ActionBuilderView;
import com.axelor.studio.db.AppBuilder;
import com.axelor.studio.db.Filter;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_ACTION_BUILDER", indexes={@Index(columnList="assign_value_to"), @Index(columnList="email_template"), @Index(columnList="app_builder"), @Index(columnList="meta_module")})
public class ActionBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_ACTION_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_ACTION_BUILDER_SEQ", sequenceName="STUDIO_ACTION_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Name")
    @Column(unique=true)
    private String name;
    @Widget(title="Type", selection="studio.action.builder.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Object")
    private String model;
    @Widget(title="Target object")
    private String targetModel;
    @Widget(title="Fields")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="actionBuilder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ActionBuilderLine> lines;
    @Widget(title="Assign value to")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField assignValueTo;
    @Widget(title="First group by")
    private String firstGroupBy;
    @Widget(title="Second group by")
    private String secondGroupBy;
    @Widget(title="Title")
    private String title;
    @Widget(title="Template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template emailTemplate;
    @Widget(title="Filters")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Filter> filters;
    @Widget(title="Transactional")
    private Boolean transactional = Boolean.FALSE;
    @Widget(title="Script type", selection="studio.action.builder.script.type.select")
    private Integer scriptType = 0;
    @Widget(title="Script")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String scriptText;
    @Widget(title="Open record")
    private Boolean openRecord = Boolean.FALSE;
    @Widget(title="Display message")
    private String displayMsg;
    @Widget(title="Send option", selection="studio.action.builder.email.send.option.select")
    private Integer emailSendOptionSelect = 0;
    @Widget(title="Condition")
    private String conditionText;
    @Widget(title="Views")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="actionBuilder", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence")
    private List<ActionBuilderView> actionBuilderViews;
    @Widget(title="Json")
    private Boolean isJson = Boolean.FALSE;
    @Widget(title="Domain")
    private String domainCondition;
    @Widget(title="View params")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ActionBuilderLine> viewParams;
    private Boolean menuAction = Boolean.FALSE;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModule metaModule;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ActionBuilder() {
    }

    public ActionBuilder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(String targetModel) {
        this.targetModel = targetModel;
    }

    public List<ActionBuilderLine> getLines() {
        return this.lines;
    }

    public void setLines(List<ActionBuilderLine> lines) {
        this.lines = lines;
    }

    public void addLine(ActionBuilderLine item) {
        if (this.getLines() == null) {
            this.setLines(new ArrayList<ActionBuilderLine>());
        }
        this.getLines().add(item);
        item.setActionBuilder(this);
    }

    public void removeLine(ActionBuilderLine item) {
        if (this.getLines() == null) {
            return;
        }
        this.getLines().remove((Object)item);
    }

    public void clearLines() {
        if (this.getLines() != null) {
            this.getLines().clear();
        }
    }

    public MetaField getAssignValueTo() {
        return this.assignValueTo;
    }

    public void setAssignValueTo(MetaField assignValueTo) {
        this.assignValueTo = assignValueTo;
    }

    public String getFirstGroupBy() {
        return this.firstGroupBy;
    }

    public void setFirstGroupBy(String firstGroupBy) {
        this.firstGroupBy = firstGroupBy;
    }

    public String getSecondGroupBy() {
        return this.secondGroupBy;
    }

    public void setSecondGroupBy(String secondGroupBy) {
        this.secondGroupBy = secondGroupBy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Template getEmailTemplate() {
        return this.emailTemplate;
    }

    public void setEmailTemplate(Template emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void addFilter(Filter item) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>());
        }
        this.getFilters().add(item);
    }

    public void removeFilter(Filter item) {
        if (this.getFilters() == null) {
            return;
        }
        this.getFilters().remove((Object)item);
    }

    public void clearFilters() {
        if (this.getFilters() != null) {
            this.getFilters().clear();
        }
    }

    public Boolean getTransactional() {
        return this.transactional == null ? Boolean.FALSE : this.transactional;
    }

    public void setTransactional(Boolean transactional) {
        this.transactional = transactional;
    }

    public Integer getScriptType() {
        return this.scriptType == null ? 0 : this.scriptType;
    }

    public void setScriptType(Integer scriptType) {
        this.scriptType = scriptType;
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
    }

    public Boolean getOpenRecord() {
        return this.openRecord == null ? Boolean.FALSE : this.openRecord;
    }

    public void setOpenRecord(Boolean openRecord) {
        this.openRecord = openRecord;
    }

    public String getDisplayMsg() {
        return this.displayMsg;
    }

    public void setDisplayMsg(String displayMsg) {
        this.displayMsg = displayMsg;
    }

    public Integer getEmailSendOptionSelect() {
        return this.emailSendOptionSelect == null ? 0 : this.emailSendOptionSelect;
    }

    public void setEmailSendOptionSelect(Integer emailSendOptionSelect) {
        this.emailSendOptionSelect = emailSendOptionSelect;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setConditionText(String conditionText) {
        this.conditionText = conditionText;
    }

    public List<ActionBuilderView> getActionBuilderViews() {
        return this.actionBuilderViews;
    }

    public void setActionBuilderViews(List<ActionBuilderView> actionBuilderViews) {
        this.actionBuilderViews = actionBuilderViews;
    }

    public void addActionBuilderView(ActionBuilderView item) {
        if (this.getActionBuilderViews() == null) {
            this.setActionBuilderViews(new ArrayList<ActionBuilderView>());
        }
        this.getActionBuilderViews().add(item);
        item.setActionBuilder(this);
    }

    public void removeActionBuilderView(ActionBuilderView item) {
        if (this.getActionBuilderViews() == null) {
            return;
        }
        this.getActionBuilderViews().remove((Object)item);
    }

    public void clearActionBuilderViews() {
        if (this.getActionBuilderViews() != null) {
            this.getActionBuilderViews().clear();
        }
    }

    public Boolean getIsJson() {
        return this.isJson == null ? Boolean.FALSE : this.isJson;
    }

    public void setIsJson(Boolean isJson) {
        this.isJson = isJson;
    }

    public String getDomainCondition() {
        return this.domainCondition;
    }

    public void setDomainCondition(String domainCondition) {
        this.domainCondition = domainCondition;
    }

    public List<ActionBuilderLine> getViewParams() {
        return this.viewParams;
    }

    public void setViewParams(List<ActionBuilderLine> viewParams) {
        this.viewParams = viewParams;
    }

    public void addViewParam(ActionBuilderLine item) {
        if (this.getViewParams() == null) {
            this.setViewParams(new ArrayList<ActionBuilderLine>());
        }
        this.getViewParams().add(item);
    }

    public void removeViewParam(ActionBuilderLine item) {
        if (this.getViewParams() == null) {
            return;
        }
        this.getViewParams().remove((Object)item);
    }

    public void clearViewParams() {
        if (this.getViewParams() != null) {
            this.getViewParams().clear();
        }
    }

    public Boolean getMenuAction() {
        return this.menuAction == null ? Boolean.FALSE : this.menuAction;
    }

    public void setMenuAction(Boolean menuAction) {
        this.menuAction = menuAction;
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public MetaModule getMetaModule() {
        return this.metaModule;
    }

    public void setMetaModule(MetaModule metaModule) {
        this.metaModule = metaModule;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActionBuilder)) {
            return false;
        }
        ActionBuilder other = (ActionBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-1876823963, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("typeSelect", (Object)this.getTypeSelect()).add("model", (Object)this.getModel()).add("targetModel", (Object)this.getTargetModel()).add("firstGroupBy", (Object)this.getFirstGroupBy()).add("secondGroupBy", (Object)this.getSecondGroupBy()).add("title", (Object)this.getTitle()).add("transactional", (Object)this.getTransactional()).add("scriptType", (Object)this.getScriptType()).add("openRecord", (Object)this.getOpenRecord()).add("displayMsg", (Object)this.getDisplayMsg()).omitNullValues().toString();
    }
}

