/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaView;
import com.axelor.studio.db.AppBuilder;
import com.axelor.studio.db.Filter;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_CHART_BUILDER", indexes={@Index(columnList="aggregate_on"), @Index(columnList="aggregate_on_json"), @Index(columnList="group_on"), @Index(columnList="group_on_json"), @Index(columnList="display_field"), @Index(columnList="display_field_json"), @Index(columnList="meta_view_generated"), @Index(columnList="app_builder")})
public class ChartBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_CHART_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_CHART_BUILDER_SEQ", sequenceName="STUDIO_CHART_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title")
    @NotNull
    private String title;
    @HashKey
    @Widget(title="Name")
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Model")
    private String model;
    @Widget(title="Json")
    private Boolean isJson = Boolean.FALSE;
    @Widget(title="Filters")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="chartBuilder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Filter> filterList;
    @Widget(title="Aggregate On")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField aggregateOn;
    @Widget(title="Json")
    private Boolean isJsonAggregateOn = Boolean.FALSE;
    @Widget(title="Aggregate On")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField aggregateOnJson;
    @Widget(title="Target")
    private String aggregateOnTarget;
    @Widget(title="Aggregate On type")
    private String aggregateOnTargetType;
    @Widget(selection="studio.chart.builder.date.type")
    private String aggregateDateType;
    @Widget(title="Group By")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField groupOn;
    @Widget(title="Json")
    private Boolean isJsonGroupOn = Boolean.FALSE;
    @Widget(title="Group By")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField groupOnJson;
    @Widget(title="Target")
    private String groupOnTarget;
    @Widget(title="Group on type")
    private String groupOnTargetType;
    @Widget(selection="studio.chart.builder.date.type")
    private String groupDateType;
    @Widget(title="Display")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField displayField;
    @Widget(selection="studio.chart.builder.display.type")
    private Integer displayType = 0;
    @Widget(title="Json")
    private Boolean isJsonDisplayField = Boolean.FALSE;
    @Widget(title="Display")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField displayFieldJson;
    @Widget(selection="studio.chart.builder.chart.type")
    private String chartType = "bar";
    @Widget(title="View generated")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView metaViewGenerated;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ChartBuilder() {
    }

    public ChartBuilder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Boolean getIsJson() {
        return this.isJson == null ? Boolean.FALSE : this.isJson;
    }

    public void setIsJson(Boolean isJson) {
        this.isJson = isJson;
    }

    public List<Filter> getFilterList() {
        return this.filterList;
    }

    public void setFilterList(List<Filter> filterList) {
        this.filterList = filterList;
    }

    public void addFilterListItem(Filter item) {
        if (this.getFilterList() == null) {
            this.setFilterList(new ArrayList<Filter>());
        }
        this.getFilterList().add(item);
        item.setChartBuilder(this);
    }

    public void removeFilterListItem(Filter item) {
        if (this.getFilterList() == null) {
            return;
        }
        this.getFilterList().remove((Object)item);
    }

    public void clearFilterList() {
        if (this.getFilterList() != null) {
            this.getFilterList().clear();
        }
    }

    public MetaField getAggregateOn() {
        return this.aggregateOn;
    }

    public void setAggregateOn(MetaField aggregateOn) {
        this.aggregateOn = aggregateOn;
    }

    public Boolean getIsJsonAggregateOn() {
        return this.isJsonAggregateOn == null ? Boolean.FALSE : this.isJsonAggregateOn;
    }

    public void setIsJsonAggregateOn(Boolean isJsonAggregateOn) {
        this.isJsonAggregateOn = isJsonAggregateOn;
    }

    public MetaJsonField getAggregateOnJson() {
        return this.aggregateOnJson;
    }

    public void setAggregateOnJson(MetaJsonField aggregateOnJson) {
        this.aggregateOnJson = aggregateOnJson;
    }

    public String getAggregateOnTarget() {
        return this.aggregateOnTarget;
    }

    public void setAggregateOnTarget(String aggregateOnTarget) {
        this.aggregateOnTarget = aggregateOnTarget;
    }

    public String getAggregateOnTargetType() {
        return this.aggregateOnTargetType;
    }

    public void setAggregateOnTargetType(String aggregateOnTargetType) {
        this.aggregateOnTargetType = aggregateOnTargetType;
    }

    public String getAggregateDateType() {
        return this.aggregateDateType;
    }

    public void setAggregateDateType(String aggregateDateType) {
        this.aggregateDateType = aggregateDateType;
    }

    public MetaField getGroupOn() {
        return this.groupOn;
    }

    public void setGroupOn(MetaField groupOn) {
        this.groupOn = groupOn;
    }

    public Boolean getIsJsonGroupOn() {
        return this.isJsonGroupOn == null ? Boolean.FALSE : this.isJsonGroupOn;
    }

    public void setIsJsonGroupOn(Boolean isJsonGroupOn) {
        this.isJsonGroupOn = isJsonGroupOn;
    }

    public MetaJsonField getGroupOnJson() {
        return this.groupOnJson;
    }

    public void setGroupOnJson(MetaJsonField groupOnJson) {
        this.groupOnJson = groupOnJson;
    }

    public String getGroupOnTarget() {
        return this.groupOnTarget;
    }

    public void setGroupOnTarget(String groupOnTarget) {
        this.groupOnTarget = groupOnTarget;
    }

    public String getGroupOnTargetType() {
        return this.groupOnTargetType;
    }

    public void setGroupOnTargetType(String groupOnTargetType) {
        this.groupOnTargetType = groupOnTargetType;
    }

    public String getGroupDateType() {
        return this.groupDateType;
    }

    public void setGroupDateType(String groupDateType) {
        this.groupDateType = groupDateType;
    }

    public MetaField getDisplayField() {
        return this.displayField;
    }

    public void setDisplayField(MetaField displayField) {
        this.displayField = displayField;
    }

    public Integer getDisplayType() {
        return this.displayType == null ? 0 : this.displayType;
    }

    public void setDisplayType(Integer displayType) {
        this.displayType = displayType;
    }

    public Boolean getIsJsonDisplayField() {
        return this.isJsonDisplayField == null ? Boolean.FALSE : this.isJsonDisplayField;
    }

    public void setIsJsonDisplayField(Boolean isJsonDisplayField) {
        this.isJsonDisplayField = isJsonDisplayField;
    }

    public MetaJsonField getDisplayFieldJson() {
        return this.displayFieldJson;
    }

    public void setDisplayFieldJson(MetaJsonField displayFieldJson) {
        this.displayFieldJson = displayFieldJson;
    }

    public String getChartType() {
        return this.chartType;
    }

    public void setChartType(String chartType) {
        this.chartType = chartType;
    }

    public MetaView getMetaViewGenerated() {
        return this.metaViewGenerated;
    }

    public void setMetaViewGenerated(MetaView metaViewGenerated) {
        this.metaViewGenerated = metaViewGenerated;
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChartBuilder)) {
            return false;
        }
        ChartBuilder other = (ChartBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-1715925507, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("name", (Object)this.getName()).add("model", (Object)this.getModel()).add("isJson", (Object)this.getIsJson()).add("isJsonAggregateOn", (Object)this.getIsJsonAggregateOn()).add("aggregateOnTarget", (Object)this.getAggregateOnTarget()).add("aggregateOnTargetType", (Object)this.getAggregateOnTargetType()).add("aggregateDateType", (Object)this.getAggregateDateType()).add("isJsonGroupOn", (Object)this.getIsJsonGroupOn()).add("groupOnTarget", (Object)this.getGroupOnTarget()).add("groupOnTargetType", (Object)this.getGroupOnTargetType()).omitNullValues().toString();
    }
}

