/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaView;
import com.axelor.studio.db.AppBuilder;
import com.axelor.studio.db.DashletBuilder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_DASHBOARD_BUILDER", indexes={@Index(columnList="meta_view_generated"), @Index(columnList="app_builder")})
public class DashboardBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_DASHBOARD_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_DASHBOARD_BUILDER_SEQ", sequenceName="STUDIO_DASHBOARD_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Title")
    @NotNull
    private String title;
    @HashKey
    @Widget(title="Name")
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Model")
    private String model;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="dashboardBuilder", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence")
    private List<DashletBuilder> dashletBuilderList;
    @Widget(title="View generated")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView metaViewGenerated;
    @Widget(title="Generated Actions")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MetaAction> generatedActions;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public DashboardBuilder() {
    }

    public DashboardBuilder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<DashletBuilder> getDashletBuilderList() {
        return this.dashletBuilderList;
    }

    public void setDashletBuilderList(List<DashletBuilder> dashletBuilderList) {
        this.dashletBuilderList = dashletBuilderList;
    }

    public void addDashletBuilderListItem(DashletBuilder item) {
        if (this.getDashletBuilderList() == null) {
            this.setDashletBuilderList(new ArrayList<DashletBuilder>());
        }
        this.getDashletBuilderList().add(item);
        item.setDashboardBuilder(this);
    }

    public void removeDashletBuilderListItem(DashletBuilder item) {
        if (this.getDashletBuilderList() == null) {
            return;
        }
        this.getDashletBuilderList().remove((Object)item);
    }

    public void clearDashletBuilderList() {
        if (this.getDashletBuilderList() != null) {
            this.getDashletBuilderList().clear();
        }
    }

    public MetaView getMetaViewGenerated() {
        return this.metaViewGenerated;
    }

    public void setMetaViewGenerated(MetaView metaViewGenerated) {
        this.metaViewGenerated = metaViewGenerated;
    }

    public List<MetaAction> getGeneratedActions() {
        return this.generatedActions;
    }

    public void setGeneratedActions(List<MetaAction> generatedActions) {
        this.generatedActions = generatedActions;
    }

    public void addGeneratedAction(MetaAction item) {
        if (this.getGeneratedActions() == null) {
            this.setGeneratedActions(new ArrayList<MetaAction>());
        }
        this.getGeneratedActions().add(item);
    }

    public void removeGeneratedAction(MetaAction item) {
        if (this.getGeneratedActions() == null) {
            return;
        }
        this.getGeneratedActions().remove((Object)item);
    }

    public void clearGeneratedActions() {
        if (this.getGeneratedActions() != null) {
            this.getGeneratedActions().clear();
        }
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DashboardBuilder)) {
            return false;
        }
        DashboardBuilder other = (DashboardBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(1864929927, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("name", (Object)this.getName()).add("model", (Object)this.getModel()).omitNullValues().toString();
    }
}

