/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaModule;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.AppBuilder;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_MENU_BUILDER", indexes={@Index(columnList="meta_menu"), @Index(columnList="parent_menu"), @Index(columnList="action_builder"), @Index(columnList="app_builder"), @Index(columnList="meta_module")})
public class MenuBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_MENU_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_MENU_BUILDER_SEQ", sequenceName="STUDIO_MENU_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Name")
    @Column(unique=true)
    private String name;
    @Widget(title="Title")
    @NotNull
    private String title;
    @Widget(title="Icon", selection="studio.menu.builder.icon.select")
    private String icon;
    @Widget(title="Background", selection="studio.menu.builder.icon.background.select")
    private String iconBackground;
    @Widget(title="MenuBuilder.Order")
    @Column(name="order_seq")
    private Integer order = 0;
    @Widget(title="Tag label")
    private String tag;
    @Widget(title="Tag method")
    private String tagGet;
    @Widget(title="Tag count")
    private Boolean tagCount = Boolean.FALSE;
    @Widget(title="Tag style", selection="label.style.selection")
    private String tagStyle;
    @Widget(title="Top menu")
    @Column(name="top_menu")
    private Boolean top = Boolean.FALSE;
    @Widget(title="Left menu")
    @Column(name="left_menu")
    private Boolean left = Boolean.TRUE;
    @Widget(title="Mobile menu")
    @Column(name="mobile_menu")
    private Boolean mobile = Boolean.FALSE;
    @Widget(title="Hidden menu")
    private Boolean hidden = Boolean.FALSE;
    private String link;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groups;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roles;
    @Widget(title="If", help="Only use this menu-item if the given expression is true.")
    @Size(max=1024)
    private String conditionToCheck;
    @Widget(title="If-module", help="Only use this menu-item if the given module is installed.")
    private String moduleToCheck;
    @Widget(title="MetaMenu")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu metaMenu;
    @Widget(title="Parent")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaMenu parentMenu;
    @Widget(title="Action")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ActionBuilder actionBuilder;
    @Widget(title="Object")
    private Boolean showAction = Boolean.FALSE;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModule metaModule;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public MenuBuilder() {
    }

    public MenuBuilder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconBackground() {
        return this.iconBackground;
    }

    public void setIconBackground(String iconBackground) {
        this.iconBackground = iconBackground;
    }

    public Integer getOrder() {
        return this.order == null ? 0 : this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTagGet() {
        return this.tagGet;
    }

    public void setTagGet(String tagGet) {
        this.tagGet = tagGet;
    }

    public Boolean getTagCount() {
        return this.tagCount == null ? Boolean.FALSE : this.tagCount;
    }

    public void setTagCount(Boolean tagCount) {
        this.tagCount = tagCount;
    }

    public String getTagStyle() {
        return this.tagStyle;
    }

    public void setTagStyle(String tagStyle) {
        this.tagStyle = tagStyle;
    }

    public Boolean getTop() {
        return this.top == null ? Boolean.FALSE : this.top;
    }

    public void setTop(Boolean top) {
        this.top = top;
    }

    public Boolean getLeft() {
        return this.left == null ? Boolean.FALSE : this.left;
    }

    public void setLeft(Boolean left) {
        this.left = left;
    }

    public Boolean getMobile() {
        return this.mobile == null ? Boolean.FALSE : this.mobile;
    }

    public void setMobile(Boolean mobile) {
        this.mobile = mobile;
    }

    public Boolean getHidden() {
        return this.hidden == null ? Boolean.FALSE : this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void addGroup(Group item) {
        if (this.getGroups() == null) {
            this.setGroups(new HashSet<Group>());
        }
        this.getGroups().add(item);
    }

    public void removeGroup(Group item) {
        if (this.getGroups() == null) {
            return;
        }
        this.getGroups().remove(item);
    }

    public void clearGroups() {
        if (this.getGroups() != null) {
            this.getGroups().clear();
        }
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role item) {
        if (this.getRoles() == null) {
            this.setRoles(new HashSet<Role>());
        }
        this.getRoles().add(item);
    }

    public void removeRole(Role item) {
        if (this.getRoles() == null) {
            return;
        }
        this.getRoles().remove(item);
    }

    public void clearRoles() {
        if (this.getRoles() != null) {
            this.getRoles().clear();
        }
    }

    public String getConditionToCheck() {
        return this.conditionToCheck;
    }

    public void setConditionToCheck(String conditionToCheck) {
        this.conditionToCheck = conditionToCheck;
    }

    public String getModuleToCheck() {
        return this.moduleToCheck;
    }

    public void setModuleToCheck(String moduleToCheck) {
        this.moduleToCheck = moduleToCheck;
    }

    public MetaMenu getMetaMenu() {
        return this.metaMenu;
    }

    public void setMetaMenu(MetaMenu metaMenu) {
        this.metaMenu = metaMenu;
    }

    public MetaMenu getParentMenu() {
        return this.parentMenu;
    }

    public void setParentMenu(MetaMenu parentMenu) {
        this.parentMenu = parentMenu;
    }

    public ActionBuilder getActionBuilder() {
        return this.actionBuilder;
    }

    public void setActionBuilder(ActionBuilder actionBuilder) {
        this.actionBuilder = actionBuilder;
    }

    public Boolean getShowAction() {
        return this.showAction == null ? Boolean.FALSE : this.showAction;
    }

    public void setShowAction(Boolean showAction) {
        this.showAction = showAction;
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public MetaModule getMetaModule() {
        return this.metaModule;
    }

    public void setMetaModule(MetaModule metaModule) {
        this.metaModule = metaModule;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MenuBuilder)) {
            return false;
        }
        MenuBuilder other = (MenuBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-904847076, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("title", (Object)this.getTitle()).add("icon", (Object)this.getIcon()).add("iconBackground", (Object)this.getIconBackground()).add("order", (Object)this.getOrder()).add("tag", (Object)this.getTag()).add("tagGet", (Object)this.getTagGet()).add("tagCount", (Object)this.getTagCount()).add("tagStyle", (Object)this.getTagStyle()).add("top", (Object)this.getTop()).add("left", (Object)this.getLeft()).omitNullValues().toString();
    }
}

