/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaSelect;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_SELECTION_BUILDER", indexes={@Index(columnList="name"), @Index(columnList="meta_select")})
public class SelectionBuilder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_SELECTION_BUILDER_SEQ")
    @SequenceGenerator(name="STUDIO_SELECTION_BUILDER_SEQ", sequenceName="STUDIO_SELECTION_BUILDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Existing selection")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaSelect metaSelect;
    @Widget(title="Selection")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String selectionText;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public SelectionBuilder() {
    }

    public SelectionBuilder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaSelect getMetaSelect() {
        return this.metaSelect;
    }

    public void setMetaSelect(MetaSelect metaSelect) {
        this.metaSelect = metaSelect;
    }

    public String getSelectionText() {
        return this.selectionText;
    }

    public void setSelectionText(String selectionText) {
        this.selectionText = selectionText;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SelectionBuilder)) {
            return false;
        }
        SelectionBuilder other = (SelectionBuilder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

