/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaView;
import com.axelor.studio.db.AppBuilder;
import com.axelor.studio.db.Filter;
import com.axelor.studio.db.WkfNode;
import com.axelor.studio.db.WkfTracking;
import com.axelor.studio.db.WkfTransition;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_WKF", indexes={@Index(columnList="name"), @Index(columnList="status_field"), @Index(columnList="status_meta_field"), @Index(columnList="app_builder"), @Index(columnList="meta_view"), @Index(columnList="generated_meta_view")})
public class Wkf
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_WKF_SEQ")
    @SequenceGenerator(name="STUDIO_WKF_SEQ", sequenceName="STUDIO_WKF_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String code;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Object")
    @NotNull
    private String model;
    @Widget(title="Json Field")
    private String jsonField;
    @Widget(title="Custom")
    private Boolean isJson = Boolean.FALSE;
    @Widget(title="Wkf field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaJsonField statusField;
    @Widget(title="Wkf field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField statusMetaField;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkf", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="sequence")
    private List<WkfNode> nodes;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkf", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WkfTransition> transitions;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkf", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WkfTracking> wkfTrackings;
    @Widget(title="Process display type", selection="studio.business.wkf.display.type.select")
    private Integer displayTypeSelect = 0;
    @Widget(title="Bpmn xml")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String bpmnXml;
    @Widget(title="App builder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppBuilder appBuilder;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Apply if")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkf", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Filter> conditions;
    @Widget(title="Wkf sequence")
    private Integer wkfSequence = 0;
    @Widget(title="Track flow")
    private Boolean isTrackFlow = Boolean.FALSE;
    @Widget(title="Select view")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView metaView;
    @Widget(title="Generated view")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaView generatedMetaView;
    @Widget(title="Wkf model")
    private String wkfModel;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Wkf() {
    }

    public Wkf(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getJsonField() {
        return this.jsonField;
    }

    public void setJsonField(String jsonField) {
        this.jsonField = jsonField;
    }

    public Boolean getIsJson() {
        return this.isJson == null ? Boolean.FALSE : this.isJson;
    }

    public void setIsJson(Boolean isJson) {
        this.isJson = isJson;
    }

    public MetaJsonField getStatusField() {
        return this.statusField;
    }

    public void setStatusField(MetaJsonField statusField) {
        this.statusField = statusField;
    }

    public MetaField getStatusMetaField() {
        return this.statusMetaField;
    }

    public void setStatusMetaField(MetaField statusMetaField) {
        this.statusMetaField = statusMetaField;
    }

    public List<WkfNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<WkfNode> nodes) {
        this.nodes = nodes;
    }

    public void addNode(WkfNode item) {
        if (this.getNodes() == null) {
            this.setNodes(new ArrayList<WkfNode>());
        }
        this.getNodes().add(item);
        item.setWkf(this);
    }

    public void removeNode(WkfNode item) {
        if (this.getNodes() == null) {
            return;
        }
        this.getNodes().remove((Object)item);
    }

    public void clearNodes() {
        if (this.getNodes() != null) {
            this.getNodes().clear();
        }
    }

    public List<WkfTransition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(List<WkfTransition> transitions) {
        this.transitions = transitions;
    }

    public void addTransition(WkfTransition item) {
        if (this.getTransitions() == null) {
            this.setTransitions(new ArrayList<WkfTransition>());
        }
        this.getTransitions().add(item);
        item.setWkf(this);
    }

    public void removeTransition(WkfTransition item) {
        if (this.getTransitions() == null) {
            return;
        }
        this.getTransitions().remove((Object)item);
    }

    public void clearTransitions() {
        if (this.getTransitions() != null) {
            this.getTransitions().clear();
        }
    }

    public List<WkfTracking> getWkfTrackings() {
        return this.wkfTrackings;
    }

    public void setWkfTrackings(List<WkfTracking> wkfTrackings) {
        this.wkfTrackings = wkfTrackings;
    }

    public void addWkfTracking(WkfTracking item) {
        if (this.getWkfTrackings() == null) {
            this.setWkfTrackings(new ArrayList<WkfTracking>());
        }
        this.getWkfTrackings().add(item);
        item.setWkf(this);
    }

    public void removeWkfTracking(WkfTracking item) {
        if (this.getWkfTrackings() == null) {
            return;
        }
        this.getWkfTrackings().remove((Object)item);
    }

    public void clearWkfTrackings() {
        if (this.getWkfTrackings() != null) {
            this.getWkfTrackings().clear();
        }
    }

    public Integer getDisplayTypeSelect() {
        return this.displayTypeSelect == null ? 0 : this.displayTypeSelect;
    }

    public void setDisplayTypeSelect(Integer displayTypeSelect) {
        this.displayTypeSelect = displayTypeSelect;
    }

    public String getBpmnXml() {
        return this.bpmnXml;
    }

    public void setBpmnXml(String bpmnXml) {
        this.bpmnXml = bpmnXml;
    }

    public AppBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public void setAppBuilder(AppBuilder appBuilder) {
        this.appBuilder = appBuilder;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Filter> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Filter> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Filter item) {
        if (this.getConditions() == null) {
            this.setConditions(new ArrayList<Filter>());
        }
        this.getConditions().add(item);
        item.setWkf(this);
    }

    public void removeCondition(Filter item) {
        if (this.getConditions() == null) {
            return;
        }
        this.getConditions().remove((Object)item);
    }

    public void clearConditions() {
        if (this.getConditions() != null) {
            this.getConditions().clear();
        }
    }

    public Integer getWkfSequence() {
        return this.wkfSequence == null ? 0 : this.wkfSequence;
    }

    public void setWkfSequence(Integer wkfSequence) {
        this.wkfSequence = wkfSequence;
    }

    public Boolean getIsTrackFlow() {
        return this.isTrackFlow == null ? Boolean.FALSE : this.isTrackFlow;
    }

    public void setIsTrackFlow(Boolean isTrackFlow) {
        this.isTrackFlow = isTrackFlow;
    }

    public MetaView getMetaView() {
        return this.metaView;
    }

    public void setMetaView(MetaView metaView) {
        this.metaView = metaView;
    }

    public MetaView getGeneratedMetaView() {
        return this.generatedMetaView;
    }

    public void setGeneratedMetaView(MetaView generatedMetaView) {
        this.generatedMetaView = generatedMetaView;
    }

    public String getWkfModel() {
        return this.wkfModel;
    }

    public void setWkfModel(String wkfModel) {
        this.wkfModel = wkfModel;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Wkf)) {
            return false;
        }
        Wkf other = (Wkf)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(87026, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).add("model", (Object)this.getModel()).add("jsonField", (Object)this.getJsonField()).add("isJson", (Object)this.getIsJson()).add("displayTypeSelect", (Object)this.getDisplayTypeSelect()).add("wkfSequence", (Object)this.getWkfSequence()).add("isTrackFlow", (Object)this.getIsTrackFlow()).add("wkfModel", (Object)this.getWkfModel()).omitNullValues().toString();
    }
}

