/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfTrackingLine;
import com.axelor.studio.db.WkfTrackingTime;
import com.axelor.studio.db.WkfTrackingTotal;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_WKF_TRACKING", indexes={@Index(columnList="wkf")})
public class WkfTracking
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_WKF_TRACKING_SEQ")
    @SequenceGenerator(name="STUDIO_WKF_TRACKING_SEQ", sequenceName="STUDIO_WKF_TRACKING_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Wkf wkf;
    @Widget(title="Record model")
    @NotNull
    private String recordModel;
    @Widget(title="Record Id")
    @NotNull
    private Long recordId = 0L;
    @Widget(title="Record name")
    private String recordName;
    @Widget(title="Tracking lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkfTracking", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WkfTrackingLine> wkfTrackingLines;
    @Widget(title="Nb of passes per status")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkfTracking", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WkfTrackingTotal> totalLines;
    @Widget(title="Time spent (hours/days)")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkfTracking", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WkfTrackingTime> totalTimeLines;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Wkf getWkf() {
        return this.wkf;
    }

    public void setWkf(Wkf wkf) {
        this.wkf = wkf;
    }

    public String getRecordModel() {
        return this.recordModel;
    }

    public void setRecordModel(String recordModel) {
        this.recordModel = recordModel;
    }

    public Long getRecordId() {
        return this.recordId == null ? 0L : this.recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public List<WkfTrackingLine> getWkfTrackingLines() {
        return this.wkfTrackingLines;
    }

    public void setWkfTrackingLines(List<WkfTrackingLine> wkfTrackingLines) {
        this.wkfTrackingLines = wkfTrackingLines;
    }

    public void addWkfTrackingLine(WkfTrackingLine item) {
        if (this.getWkfTrackingLines() == null) {
            this.setWkfTrackingLines(new ArrayList<WkfTrackingLine>());
        }
        this.getWkfTrackingLines().add(item);
        item.setWkfTracking(this);
    }

    public void removeWkfTrackingLine(WkfTrackingLine item) {
        if (this.getWkfTrackingLines() == null) {
            return;
        }
        this.getWkfTrackingLines().remove((Object)item);
    }

    public void clearWkfTrackingLines() {
        if (this.getWkfTrackingLines() != null) {
            this.getWkfTrackingLines().clear();
        }
    }

    public List<WkfTrackingTotal> getTotalLines() {
        return this.totalLines;
    }

    public void setTotalLines(List<WkfTrackingTotal> totalLines) {
        this.totalLines = totalLines;
    }

    public void addTotalLine(WkfTrackingTotal item) {
        if (this.getTotalLines() == null) {
            this.setTotalLines(new ArrayList<WkfTrackingTotal>());
        }
        this.getTotalLines().add(item);
        item.setWkfTracking(this);
    }

    public void removeTotalLine(WkfTrackingTotal item) {
        if (this.getTotalLines() == null) {
            return;
        }
        this.getTotalLines().remove((Object)item);
    }

    public void clearTotalLines() {
        if (this.getTotalLines() != null) {
            this.getTotalLines().clear();
        }
    }

    public List<WkfTrackingTime> getTotalTimeLines() {
        return this.totalTimeLines;
    }

    public void setTotalTimeLines(List<WkfTrackingTime> totalTimeLines) {
        this.totalTimeLines = totalTimeLines;
    }

    public void addTotalTimeLine(WkfTrackingTime item) {
        if (this.getTotalTimeLines() == null) {
            this.setTotalTimeLines(new ArrayList<WkfTrackingTime>());
        }
        this.getTotalTimeLines().add(item);
        item.setWkfTracking(this);
    }

    public void removeTotalTimeLine(WkfTrackingTime item) {
        if (this.getTotalTimeLines() == null) {
            return;
        }
        this.getTotalTimeLines().remove((Object)item);
    }

    public void clearTotalTimeLines() {
        if (this.getTotalTimeLines() != null) {
            this.getTotalTimeLines().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WkfTracking)) {
            return false;
        }
        WkfTracking other = (WkfTracking)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("recordModel", (Object)this.getRecordModel()).add("recordId", (Object)this.getRecordId()).add("recordName", (Object)this.getRecordName()).omitNullValues().toString();
    }
}

