/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.Widget;
import com.axelor.studio.db.Filter;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfNode;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STUDIO_WKF_TRANSITION", indexes={@Index(columnList="name"), @Index(columnList="wkf"), @Index(columnList="source"), @Index(columnList="target")})
public class WkfTransition
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STUDIO_WKF_TRANSITION_SEQ")
    @SequenceGenerator(name="STUDIO_WKF_TRANSITION_SEQ", sequenceName="STUDIO_WKF_TRANSITION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="xmlId")
    private String xmlId;
    @Widget(title="Button")
    private Boolean isButton = Boolean.FALSE;
    @Widget(title="Button title")
    private String buttonTitle;
    @Widget(title="Colspan")
    @Min(value=1L)
    @Max(value=12L)
    private Integer colSpan = 3;
    @Widget(title="Roles")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roleSet;
    @Widget(title="Conditions")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wkfTransition", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Filter> conditions;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Wkf wkf;
    @Widget(title="From")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WkfNode source;
    @Widget(title="To")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WkfNode target;
    @Widget(title="Alert or Blocking condition", selection="studio.condition.alert.type.select")
    private Integer alertTypeSelect = 0;
    @Widget(title="Message on alert or blocking")
    private String alertMsg;
    @Widget(title="Message on success")
    private String successMsg;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public WkfTransition() {
    }

    public WkfTransition(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public Boolean getIsButton() {
        return this.isButton == null ? Boolean.FALSE : this.isButton;
    }

    public void setIsButton(Boolean isButton) {
        this.isButton = isButton;
    }

    public String getButtonTitle() {
        return this.buttonTitle;
    }

    public void setButtonTitle(String buttonTitle) {
        this.buttonTitle = buttonTitle;
    }

    public Integer getColSpan() {
        return this.colSpan == null ? 0 : this.colSpan;
    }

    public void setColSpan(Integer colSpan) {
        this.colSpan = colSpan;
    }

    public Set<Role> getRoleSet() {
        return this.roleSet;
    }

    public void setRoleSet(Set<Role> roleSet) {
        this.roleSet = roleSet;
    }

    public void addRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            this.setRoleSet(new HashSet<Role>());
        }
        this.getRoleSet().add(item);
    }

    public void removeRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            return;
        }
        this.getRoleSet().remove(item);
    }

    public void clearRoleSet() {
        if (this.getRoleSet() != null) {
            this.getRoleSet().clear();
        }
    }

    public List<Filter> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Filter> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Filter item) {
        if (this.getConditions() == null) {
            this.setConditions(new ArrayList<Filter>());
        }
        this.getConditions().add(item);
        item.setWkfTransition(this);
    }

    public void removeCondition(Filter item) {
        if (this.getConditions() == null) {
            return;
        }
        this.getConditions().remove((Object)item);
    }

    public void clearConditions() {
        if (this.getConditions() != null) {
            this.getConditions().clear();
        }
    }

    public Wkf getWkf() {
        return this.wkf;
    }

    public void setWkf(Wkf wkf) {
        this.wkf = wkf;
    }

    public WkfNode getSource() {
        return this.source;
    }

    public void setSource(WkfNode source) {
        this.source = source;
    }

    public WkfNode getTarget() {
        return this.target;
    }

    public void setTarget(WkfNode target) {
        this.target = target;
    }

    public Integer getAlertTypeSelect() {
        return this.alertTypeSelect == null ? 0 : this.alertTypeSelect;
    }

    public void setAlertTypeSelect(Integer alertTypeSelect) {
        this.alertTypeSelect = alertTypeSelect;
    }

    public String getAlertMsg() {
        return this.alertMsg;
    }

    public void setAlertMsg(String alertMsg) {
        this.alertMsg = alertMsg;
    }

    public String getSuccessMsg() {
        return this.successMsg;
    }

    public void setSuccessMsg(String successMsg) {
        this.successMsg = successMsg;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WkfTransition)) {
            return false;
        }
        WkfTransition other = (WkfTransition)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("xmlId", (Object)this.getXmlId()).add("isButton", (Object)this.getIsButton()).add("buttonTitle", (Object)this.getButtonTitle()).add("colSpan", (Object)this.getColSpan()).add("alertTypeSelect", (Object)this.getAlertTypeSelect()).add("alertMsg", (Object)this.getAlertMsg()).add("successMsg", (Object)this.getSuccessMsg()).omitNullValues().toString();
    }
}

