/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.db.repo;

import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.studio.db.ChartBuilder;
import com.axelor.studio.db.repo.ChartBuilderRepository;
import com.axelor.studio.service.builder.ChartBuilderService;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBException;

public class ChartBuilderRepo
extends ChartBuilderRepository {
    @Inject
    private MetaViewRepository metaViewRepo;
    @Inject
    private ChartBuilderService chartBuilderService;

    public ChartBuilder save(ChartBuilder chartBuilder) throws ValidationException {
        try {
            this.chartBuilderService.build(chartBuilder);
        }
        catch (AxelorException | JAXBException e) {
            this.refresh((Model)((Object)chartBuilder));
            throw new ValidationException(e.getMessage());
        }
        return (ChartBuilder)((Object)super.save((Model)((Object)chartBuilder)));
    }

    @Transactional
    public void remove(ChartBuilder chartBuilder) {
        MetaView metaView = chartBuilder.getMetaViewGenerated();
        List chartBuilders = this.all().filter("self.metaViewGenerated = ?1 and self.id != ?2", new Object[]{metaView, chartBuilder.getId()}).fetch();
        for (ChartBuilder builder : chartBuilders) {
            builder.setMetaViewGenerated(null);
        }
        if (metaView != null) {
            this.metaViewRepo.remove((Model)metaView);
        }
        super.remove((Model)((Object)chartBuilder));
    }
}

