/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service;

import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.AppBuilder;
import com.axelor.studio.db.ChartBuilder;
import com.axelor.studio.db.DashboardBuilder;
import com.axelor.studio.db.MenuBuilder;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.repo.ActionBuilderRepository;
import com.axelor.studio.db.repo.AppBuilderRepository;
import com.axelor.studio.db.repo.ChartBuilderRepository;
import com.axelor.studio.db.repo.DashboardBuilderRepository;
import com.axelor.studio.db.repo.MenuBuilderRepository;
import com.axelor.studio.service.wkf.WkfService;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class ImportService {
    @Inject
    private ChartBuilderRepository chartBuilderRepo;
    @Inject
    private MetaJsonModelRepository metaJsonModelRepo;
    @Inject
    private MetaJsonFieldRepository metaJsonFieldRepo;
    @Inject
    private DashboardBuilderRepository dashboardBuilderRepo;
    @Inject
    private MenuBuilderRepository menuBuilderRepo;
    @Inject
    private ActionBuilderRepository actionBuilderRepo;
    @Inject
    private AppBuilderRepository appBuilderRepo;
    @Inject
    private WkfService wkfService;
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private MetaFileRepository metaFileRepo;

    public Object importMetaJsonModel(Object bean, Map<String, Object> values) {
        assert (bean instanceof MetaJsonModel);
        return this.metaJsonModelRepo.save((MetaJsonModel)((Object)bean));
    }

    public Object importMetaJsonField(Object bean, Map<String, Object> values) {
        assert (bean instanceof MetaJsonField);
        return this.metaJsonFieldRepo.save((Model)((Object)((MetaJsonField)((Object)bean))));
    }

    public Object importChartBuilder(Object bean, Map<String, Object> values) throws JAXBException, AxelorException {
        assert (bean instanceof ChartBuilder);
        return this.chartBuilderRepo.save((Model)((Object)((ChartBuilder)((Object)bean))));
    }

    public Object importDashboardBuilder(Object bean, Map<String, Object> values) {
        assert (bean instanceof DashboardBuilder);
        return this.dashboardBuilderRepo.save((Model)((Object)((DashboardBuilder)((Object)bean))));
    }

    public Object importMenuBuilder(Object bean, Map<String, Object> values) {
        assert (bean instanceof MenuBuilder);
        return this.menuBuilderRepo.save((Model)((Object)((MenuBuilder)((Object)bean))));
    }

    public Object importActionBuilder(Object bean, Map<String, Object> values) {
        assert (bean instanceof ActionBuilder);
        return this.actionBuilderRepo.save((Model)((Object)((ActionBuilder)((Object)bean))));
    }

    public Object importWkf(Object bean, Map<String, Object> values) throws Exception {
        assert (bean instanceof Wkf);
        Wkf wkf = (Wkf)((Object)bean);
        this.wkfService.process(wkf);
        return wkf;
    }

    public Object importAppBuilderImg(Object bean, Map<String, Object> values) {
        assert (bean instanceof AppBuilder);
        AppBuilder appBuilder = (AppBuilder)((Object)bean);
        String fileName = (String)values.get("fileName");
        String imageData = (String)values.get("imageData");
        if (fileName != null && imageData != null) {
            appBuilder.setImage(this.importImg(fileName, imageData));
        }
        appBuilder = (AppBuilder)((Object)this.appBuilderRepo.save((Model)((Object)appBuilder)));
        return appBuilder;
    }

    public Object importAppBuilder(Object bean, Map<String, Object> values) {
        assert (bean instanceof AppBuilder);
        AppBuilder appBuilder = (AppBuilder)((Object)bean);
        return this.appBuilderRepo.save((Model)((Object)appBuilder));
    }

    private MetaFile importImg(String name, String data) {
        if (data == null) {
            return null;
        }
        byte[] img = Base64.getDecoder().decode(data);
        ByteArrayInputStream inImg = new ByteArrayInputStream(img);
        MetaFile metaFile = (MetaFile)this.metaFileRepo.all().filter("self.fileName = ?1", new Object[]{name}).fetchOne();
        try {
            if (metaFile != null) {
                return this.metaFiles.upload((InputStream)inImg, metaFile);
            }
            return this.metaFiles.upload((InputStream)inImg, name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MetaJsonField importJsonModelField(Object bean, Map<String, Object> values) {
        assert (bean instanceof MetaJsonField);
        MetaJsonField field = (MetaJsonField)((Object)bean);
        if (field.getJsonModel() == null) {
            return null;
        }
        return field;
    }

    public MetaJsonField importJsonField(Object bean, Map<String, Object> values) {
        assert (bean instanceof MetaJsonField);
        MetaJsonField field = (MetaJsonField)((Object)bean);
        if (field.getJsonModel() != null) {
            return null;
        }
        return field;
    }

    public Object importAppMetaJsonModel(Object bean, Map<String, Object> values) {
        assert (bean instanceof MetaJsonModel);
        MetaJsonModel model = (MetaJsonModel)((Object)bean);
        JPA.flush();
        JPA.refresh((Model)((Object)model));
        return this.metaJsonModelRepo.save(model);
    }

    public Object importAppDashboardBuilder(Object bean, Map<String, Object> values) {
        assert (bean instanceof DashboardBuilder);
        DashboardBuilder dashboard = (DashboardBuilder)((Object)bean);
        JPA.flush();
        JPA.refresh((Model)((Object)dashboard));
        return this.dashboardBuilderRepo.save((Model)((Object)dashboard));
    }

    public Object importAppWkf(Object bean, Map<String, Object> values) throws Exception {
        assert (bean instanceof Wkf);
        Wkf wkf = (Wkf)((Object)bean);
        JPA.flush();
        JPA.refresh((Model)((Object)wkf));
        this.wkfService.process(wkf);
        return wkf;
    }
}

