/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service;

import com.axelor.meta.db.MetaJsonField;
import com.axelor.studio.service.builder.SelectionBuilderService;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class JsonFieldService {
    public static final String SELECTION_PREFIX = "custom-json-select-";
    @Inject
    private SelectionBuilderService selectionBuilderService;

    @Transactional
    public void updateSelection(MetaJsonField metaJsonField) {
        String selectionText = metaJsonField.getSelectionText();
        String name = SELECTION_PREFIX + metaJsonField.getId();
        if (Strings.isNullOrEmpty((String)selectionText)) {
            this.selectionBuilderService.removeSelection(name, null);
            if (metaJsonField.getSelection() != null && metaJsonField.getSelection().equals(SELECTION_PREFIX + metaJsonField.getId())) {
                metaJsonField.setSelection(null);
            }
            return;
        }
        metaJsonField.setSelection(this.selectionBuilderService.updateMetaSelectFromText(selectionText, name, null));
    }

    @Transactional
    public void removeSelection(MetaJsonField metaJsonField) {
        String name = SELECTION_PREFIX + metaJsonField.getId();
        if (metaJsonField.getSelection() != null && metaJsonField.getSelection().equals(name)) {
            this.selectionBuilderService.removeSelection(name, null);
        }
    }
}

