/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.User;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaActionRepository;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.studio.db.MenuBuilder;
import com.axelor.studio.db.repo.MenuBuilderRepository;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioMetaService {
    public static final String XML_ID_PREFIX = "studio-build-";
    private final Logger log = LoggerFactory.getLogger(StudioMetaService.class);
    @Inject
    private MetaActionRepository metaActionRepo;
    @Inject
    private MetaViewRepository metaViewRepo;
    @Inject
    private MetaMenuRepository metaMenuRepo;
    @Inject
    private MenuBuilderRepository menuBuilderRepo;
    @Inject
    private MetaModelRepository metaModelRepo;

    @Transactional
    public void removeMetaActions(String actionNames) {
        this.log.debug("Removing actions: {}", (Object)actionNames);
        if (actionNames == null) {
            return;
        }
        actionNames = actionNames.replaceAll("action-wkf-open-wkf-tracking", "");
        List metaActions = this.metaActionRepo.all().filter("self.name in ?1", new Object[]{Arrays.asList(actionNames.split(","))}).fetch();
        for (MetaAction action : metaActions) {
            if (action.getXmlId() == null || !action.getXmlId().contentEquals(XML_ID_PREFIX + action.getName())) continue;
            List menus = this.metaMenuRepo.all().filter("self.action = ?1", new Object[]{action}).fetch();
            for (MetaMenu metaMenu : menus) {
                metaMenu.setAction(null);
                this.metaMenuRepo.save((Model)metaMenu);
            }
            this.metaActionRepo.remove((Model)((Object)action));
        }
    }

    @Transactional
    public MetaAction updateMetaAction(String name, String actionType, String xml, String model) {
        String xmlId = XML_ID_PREFIX + name;
        MetaAction action = this.metaActionRepo.findByID(xmlId);
        if (action == null) {
            action = new MetaAction(name);
            action.setXmlId(xmlId);
            Integer priority = this.getPriority(MetaAction.class.getSimpleName(), name);
            action.setPriority(priority);
        }
        action.setType(actionType);
        action.setModel(model);
        action.setXml(xml);
        return (MetaAction)((Object)this.metaActionRepo.save((Model)((Object)action)));
    }

    @Transactional
    public MetaView generateMetaView(AbstractView view) {
        String name = view.getName();
        String xmlId = view.getXmlId();
        String model = view.getModel();
        String viewType = view.getType();
        this.log.debug("Search view name: {}, xmlId: {}", (Object)name, (Object)xmlId);
        MetaView metaView = xmlId != null ? (MetaView)this.metaViewRepo.all().filter("self.name = ?1 and self.xmlId = ?2 and self.type = ?3", new Object[]{name, xmlId, viewType}).fetchOne() : (MetaView)this.metaViewRepo.all().filter("self.name = ?1 and self.type = ?2", new Object[]{name, viewType}).fetchOne();
        this.log.debug("Meta view found: {}", (Object)metaView);
        if (metaView == null) {
            metaView = (MetaView)this.metaViewRepo.all().filter("self.name = ?1 and self.type = ?2", new Object[]{name, viewType}).order("-priority").fetchOne();
            Integer priority = 20;
            if (metaView != null) {
                priority = metaView.getPriority() + 1;
            }
            metaView = new MetaView();
            metaView.setName(name);
            metaView.setXmlId(xmlId);
            metaView.setModel(model);
            metaView.setPriority(priority);
            metaView.setType(viewType);
            metaView.setTitle(view.getTitle());
        }
        String viewXml = XMLViews.toXml((Object)view, (boolean)true);
        metaView.setXml(viewXml);
        return (MetaView)this.metaViewRepo.save((Model)metaView);
    }

    public String updateAction(String oldAction, String newAction, boolean remove) {
        if (oldAction == null) {
            return newAction;
        }
        if (newAction == null) {
            return oldAction;
        }
        if (remove) {
            oldAction = oldAction.replace(newAction, "");
        } else if (!oldAction.contains(newAction)) {
            oldAction = oldAction + "," + newAction;
        }
        oldAction = oldAction.replace(",,", ",");
        if (oldAction.isEmpty()) {
            return null;
        }
        return oldAction;
    }

    public MetaMenu createMenu(MenuBuilder builder) {
        String xmlId = XML_ID_PREFIX + builder.getName();
        MetaMenu menu = this.metaMenuRepo.findByID(xmlId);
        if (menu == null) {
            menu = new MetaMenu(builder.getName());
            menu.setXmlId(xmlId);
            Integer priority = this.getPriority(MetaMenu.class.getSimpleName(), menu.getName());
            menu.setPriority(priority);
            menu.setTitle(builder.getTitle());
            menu = (MetaMenu)this.metaMenuRepo.save((Model)menu);
        }
        menu.setTitle(builder.getTitle());
        menu.setIcon(builder.getIcon());
        menu.setIconBackground(builder.getIconBackground());
        menu.setOrder(builder.getOrder());
        menu.setParent(builder.getParentMenu());
        if (builder.getGroups() != null) {
            HashSet<Group> groups = new HashSet<Group>();
            groups.addAll(builder.getGroups());
            menu.setGroups(groups);
        }
        if (builder.getRoles() != null) {
            HashSet<Role> roles = new HashSet<Role>();
            roles.addAll(builder.getRoles());
            menu.setRoles(roles);
        }
        String condition = builder.getConditionToCheck();
        if (builder.getAppBuilder() != null) {
            condition = condition != null ? "__config__.app.isApp('" + builder.getAppBuilder().getCode() + "') && (" + condition + ")" : "__config__.app.isApp('" + builder.getAppBuilder().getCode() + "')";
        }
        menu.setConditionToCheck(condition);
        menu.setModuleToCheck(builder.getModuleToCheck());
        menu.setLeft(builder.getLeft());
        menu.setTop(builder.getTop());
        menu.setHidden(builder.getHidden());
        menu.setMobile(builder.getMobile());
        menu.setTag(builder.getTag());
        menu.setTagCount(builder.getTagCount());
        menu.setTagGet(builder.getTagGet());
        menu.setTagStyle(builder.getTagStyle());
        menu.setLink(builder.getLink());
        if (builder.getMetaModule() != null) {
            menu.setModule(builder.getMetaModule().getName());
        }
        return menu;
    }

    @Transactional
    public void removeMetaMenu(MetaMenu metaMenu) {
        Preconditions.checkNotNull((Object)metaMenu, (Object)"metaMenu cannot be null.");
        List subMenus = this.metaMenuRepo.all().filter("self.parent = ?1", new Object[]{metaMenu}).fetch();
        for (MetaMenu subMenu : subMenus) {
            subMenu.setParent(null);
        }
        List subBuilders = this.menuBuilderRepo.all().filter("self.parentMenu = ?1", new Object[]{metaMenu}).fetch();
        for (MenuBuilder subBuilder : subBuilders) {
            subBuilder.setParentMenu(null);
            this.menuBuilderRepo.save((Model)((Object)subBuilder));
        }
        this.metaMenuRepo.remove((Model)metaMenu);
    }

    private Integer getPriority(String object, String name) {
        String query = String.format("SELECT MAX(obj.priority) FROM %s obj WHERE obj.name = :name", object);
        try {
            Optional<Object> priorityOpt = Optional.ofNullable(JPA.em().createQuery(query, Integer.class).setParameter("name", (Object)name).getSingleResult());
            return (Integer)priorityOpt.orElse(0) + 1;
        }
        catch (NoResultException e) {
            return 0;
        }
    }

    @Transactional
    public void trackJsonField(MetaJsonModel jsonModel) {
        ArrayList<MetaJsonField> jsonFieldList;
        String messageBody = "";
        List<MetaJsonField> metaJsonFieldList = jsonModel.getFields();
        if (metaJsonFieldList.equals(jsonFieldList = new ArrayList<MetaJsonField>((jsonModel = (MetaJsonModel)((Object)((MetaJsonModelRepository)Beans.get(MetaJsonModelRepository.class)).find(jsonModel.getId()))).getFields()))) {
            return;
        }
        ArrayList<MetaJsonField> commonJsonFieldList = new ArrayList<MetaJsonField>(jsonFieldList);
        commonJsonFieldList.retainAll(metaJsonFieldList);
        metaJsonFieldList.removeAll(jsonFieldList);
        if (!metaJsonFieldList.isEmpty()) {
            messageBody = metaJsonFieldList.stream().map(list -> list.getName()).collect(Collectors.joining(", "));
            this.trackingFields(jsonModel, messageBody, "Field added");
        }
        jsonFieldList.removeAll(commonJsonFieldList);
        if (!jsonFieldList.isEmpty()) {
            messageBody = jsonFieldList.stream().map(list -> list.getName()).collect(Collectors.joining(", "));
            this.trackingFields(jsonModel, messageBody, "Field removed");
        }
    }

    @Transactional
    public void trackingFields(AuditableModel auditableModel, String messageBody, String messageSubject) {
        User user = AuthUtils.getUser();
        MailMessage message = new MailMessage();
        Mapper mapper = Mapper.of(auditableModel.getClass());
        message.setSubject(messageSubject);
        message.setAuthor(user);
        message.setBody(messageBody);
        message.setRelatedId(auditableModel.getId());
        message.setRelatedModel(EntityHelper.getEntityClass((Object)auditableModel).getName());
        message.setType("notification");
        message.setRelatedName(mapper.getNameField().get((Object)auditableModel).toString());
        ((MailMessageRepository)Beans.get(MailMessageRepository.class)).save(message);
    }

    @Transactional
    public void trackJsonField(MetaJsonField metaJsonField) {
        MetaModel metaModel = (MetaModel)this.metaModelRepo.all().filter("self.fullName = ?1", new Object[]{metaJsonField.getModel()}).fetchOne();
        this.trackingFields((AuditableModel)metaModel, metaJsonField.getName(), "Field added");
    }
}

