/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.ActionBuilderView;
import com.axelor.studio.service.builder.ActionEmailBuilderService;
import com.axelor.studio.service.builder.ActionScriptBuilderService;
import com.axelor.studio.service.builder.ActionViewBuilderService;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionBuilderService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private ActionViewBuilderService actionViewBuilderService;
    @Inject
    private ActionScriptBuilderService actionScriptBuilderService;
    @Inject
    private ActionEmailBuilderService actionEmailBuilderService;

    @Transactional
    public MetaAction build(ActionBuilder builder) {
        if (builder == null) {
            return null;
        }
        this.log.debug("Processing action: {}, type: {}", (Object)builder.getName(), (Object)builder.getTypeSelect());
        if (Arrays.asList(0, 1).contains(builder.getTypeSelect()) && (builder.getLines() == null || builder.getLines().isEmpty())) {
            return null;
        }
        MetaAction metaAction = null;
        switch (builder.getTypeSelect()) {
            case 0: {
                metaAction = this.actionScriptBuilderService.build(builder);
                break;
            }
            case 1: {
                metaAction = this.actionScriptBuilderService.build(builder);
                break;
            }
            case 2: {
                metaAction = this.actionScriptBuilderService.build(builder);
                break;
            }
            case 3: {
                metaAction = this.actionViewBuilderService.build(builder);
                break;
            }
            case 4: {
                metaAction = this.actionEmailBuilderService.build(builder);
            }
        }
        if (builder.getMetaModule() != null) {
            metaAction.setModule(builder.getMetaModule().getName());
        }
        MetaStore.clear();
        return metaAction;
    }

    public ActionBuilder setActionBuilderViews(ActionBuilder actionBuilder, String modelName, String formViewName, String gridViewName) {
        if (actionBuilder.getActionBuilderViews() == null) {
            actionBuilder.setActionBuilderViews(new ArrayList<ActionBuilderView>());
        }
        List<ActionBuilderView> actionBuilderViews = actionBuilder.getActionBuilderViews();
        if (formViewName != null) {
            this.setActionBuilderView("form", formViewName, actionBuilderViews);
        }
        if (gridViewName != null) {
            this.setActionBuilderView("grid", gridViewName, actionBuilderViews);
        }
        actionBuilder.setModel(modelName);
        return actionBuilder;
    }

    private void setActionBuilderView(String viewType, String viewName, List<ActionBuilderView> actionBuilderViews) {
        ActionBuilderView actionBuilderView = new ActionBuilderView();
        actionBuilderView.setViewType(viewType);
        actionBuilderView.setViewName(viewName);
        actionBuilderViews.add(actionBuilderView);
    }
}

