/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.common.Inflector;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.ActionBuilderLine;
import com.axelor.studio.db.repo.ActionBuilderLineRepository;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.filter.FilterSqlService;
import com.axelor.studio.service.wkf.WkfTrackingService;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionScriptBuilderService {
    private static final String INDENT = "\t";
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Inflector inflector = Inflector.getInstance();
    private List<StringBuilder> fbuilder = null;
    private int varCount = 0;
    private boolean isCreate = false;
    @Inject
    private ActionBuilderLineRepository builderLineRepo;
    @Inject
    private StudioMetaService metaService;
    @Inject
    private FilterSqlService filterSqlService;

    public MetaAction build(ActionBuilder builder) {
        String name = builder.getName();
        String code = null;
        String lang = "js";
        String transactional = "true";
        if (builder.getTypeSelect() == 2) {
            code = "\n" + builder.getScriptText();
            if (builder.getScriptType() == 1) {
                lang = "groovy";
            }
            if (builder.getTransactional().booleanValue()) {
                transactional = "false";
            }
        } else {
            code = this.generateScriptCode(builder);
        }
        String xml = "<action-script name=\"" + name + "\" id=\"studio-" + name + "\" model=\"" + MetaJsonRecord.class.getName() + "\">\n\t<script language=\"" + lang + "\" transactional=\"" + transactional + "\">\n\t<![CDATA[" + code + "\n\t]]>\n\t</script>\n</action-script>";
        return this.metaService.updateMetaAction(builder.getName(), "action-script", xml, null);
    }

    private String generateScriptCode(ActionBuilder builder) {
        StringBuilder stb = new StringBuilder();
        this.fbuilder = new ArrayList<StringBuilder>();
        this.varCount = 1;
        int level = 1;
        String condition = builder.getConditionText();
        stb.append(condition == null ? this.format("var ctx = $request.context;", level) : this.format("var ctx = $request.context;", level) + "\n" + this.format("if(" + condition.replaceAll("\\$.", "ctx.") + "){", level));
        if (builder.getTypeSelect() == 0) {
            String targetModel = builder.getTargetModel();
            this.isCreate = true;
            this.addCreateCode(builder.getIsJson(), stb, level, targetModel);
            if (builder.getOpenRecord().booleanValue()) {
                this.addOpenRecord(builder.getIsJson(), stb, level, targetModel);
            }
            if (!Strings.isNullOrEmpty((String)builder.getDisplayMsg())) {
                stb.append("\n");
                stb.append(this.format("$response.setFlash('" + builder.getDisplayMsg() + "')", level));
            }
        } else {
            String targetModel = builder.getModel();
            this.isCreate = false;
            this.addUpdateCode(builder.getIsJson(), stb, level, targetModel);
        }
        stb.append(condition == null ? "\n" : this.format("}", level) + "\n");
        this.addRootFunction(builder, stb, level);
        stb.append(Joiner.on((String)"").join(this.fbuilder));
        return stb.toString();
    }

    private void addCreateCode(boolean isJson, StringBuilder stb, int level, String targetModel) {
        if (isJson) {
            stb.append(this.format("var target = $json.create('" + targetModel + "');", level));
            stb.append(this.format("target = setVar0(null, ctx, {});", level));
            stb.append(this.format("target = $json.save(target);", level));
            stb.append(this.format("Beans.get(" + WkfTrackingService.class.getName() + ".class).track(0, target, false);", level));
        } else {
            stb.append(this.format("var target = new " + targetModel + "();", level));
            stb.append(this.format("target = setVar0(null, ctx, {});", level));
            stb.append(this.format("$em.persist(target);", level));
        }
    }

    private void addOpenRecord(boolean isJson, StringBuilder stb, int level, String targetModel) {
        stb.append("\n");
        if (isJson) {
            String title = this.inflector.humanize(targetModel);
            stb.append(this.format("$response.setView(com.axelor.meta.schema.actions.ActionView.define('" + title + "')", level));
            stb.append(this.format(".model('com.axelor.meta.db.MetaJsonRecord')", level + 1));
            stb.append(this.format(".add('grid','custom-model-" + targetModel + "-grid')", level + 1));
            stb.append(this.format(".add('form','custom-model-" + targetModel + "-form')", level + 1));
            stb.append(this.format(".domain('self.jsonModel = :jsonModel')", level + 1));
            stb.append(this.format(".context('jsonModel', '" + targetModel + "')", level + 1));
            stb.append(this.format(".context('_showRecord', target.id)", level + 1));
            stb.append(this.format(".map())", level + 1));
        } else {
            String title = this.inflector.humanize(targetModel.substring(targetModel.lastIndexOf(46) + 1));
            stb.append(this.format("$response.setView(com.axelor.meta.schema.actions.ActionView.define('" + title + "')", level));
            stb.append(this.format(".model('" + targetModel + "')", level + 1));
            stb.append(this.format(".add('grid')", level + 1));
            stb.append(this.format(".add('form')", level + 1));
            stb.append(this.format(".context('_showRecord', target.id)", level + 1));
            stb.append(this.format(".map())", level + 1));
        }
    }

    private void addUpdateCode(boolean isJson, StringBuilder stb, int level, String targetModel) {
        if (isJson) {
            stb.append(this.format("var target = {};", level));
        } else {
            stb.append(this.format("var target = ctx.asType(" + targetModel + ".class)", level));
        }
        stb.append(this.format("target = setVar0(null, ctx, {});", level));
        stb.append(this.format("$response.setValues(target);", level));
    }

    private void addRootFunction(ActionBuilder builder, StringBuilder stb, int level) {
        stb.append(this.format("function setVar0($$, $, _$){", level));
        String bindings = this.addFieldsBinding("target", builder.getLines(), level + 1);
        stb.append(bindings);
        stb.append(this.format("return target;", level + 1));
        stb.append(this.format("}", level));
    }

    private String format(String line, int level) {
        return "\n" + Strings.repeat((String)INDENT, (int)level) + line;
    }

    private String addFieldsBinding(String target, List<ActionBuilderLine> lines, int level) {
        StringBuilder stb = new StringBuilder();
        lines.sort((l1, l2) -> {
            if (l1.getDummy().booleanValue() && !l2.getDummy().booleanValue()) {
                return -1;
            }
            if (!l1.getDummy().booleanValue() && l2.getDummy().booleanValue()) {
                return 1;
            }
            return 0;
        });
        for (ActionBuilderLine line : lines) {
            String condition;
            String name = line.getName();
            String value = line.getValue();
            if (value != null && value.contains(".sum(")) {
                value = this.getSum(value, line.getFilter());
            }
            if (line.getDummy().booleanValue()) {
                stb.append(this.format("_$." + name + " = " + value + ";", level));
                continue;
            }
            MetaJsonField jsonField = line.getMetaJsonField();
            MetaField metaField = line.getMetaField();
            if (jsonField != null && (jsonField.getTargetJsonModel() != null || jsonField.getTargetModel() != null)) {
                value = this.addRelationalBinding(line, target, true);
            } else if (metaField != null && metaField.getRelationship() != null) {
                value = this.addRelationalBinding(line, target, false);
            }
            if (value != null && metaField != null && metaField.getTypeName().equals(BigDecimal.class.getSimpleName())) {
                value = "new BigDecimal(" + value + ")";
            }
            if ((condition = line.getConditionText()) != null) {
                stb.append(this.format("if(" + condition + "){" + target + "." + name + " = " + value + ";}", level));
                continue;
            }
            stb.append(this.format(target + "." + name + " = " + value + ";", level));
        }
        return stb.toString();
    }

    private String addRelationalBinding(ActionBuilderLine line, String target, boolean json) {
        String type;
        line = (ActionBuilderLine)((Object)this.builderLineRepo.find(line.getId()));
        String subCode = null;
        switch (type = json ? line.getMetaJsonField().getType() : this.inflector.dasherize(line.getMetaField().getRelationship())) {
            case "many-to-one": {
                subCode = this.addM2OBinding(line, true, true);
                break;
            }
            case "many-to-many": {
                subCode = this.addM2MBinding(line);
                break;
            }
            case "one-to-many": {
                subCode = this.addO2MBinding(line, target);
                break;
            }
            case "one-to-one": {
                subCode = this.addM2OBinding(line, true, true);
                break;
            }
            case "json-many-to-one": {
                subCode = this.addJsonM2OBinding(line, true, true);
                break;
            }
            case "json-many-to-many": {
                subCode = this.addJsonM2MBinding(line);
                break;
            }
            case "json-one-to-many": {
                subCode = this.addJsonO2MBinding(line);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
        return subCode + "($," + line.getValue() + ", _$)";
    }

    private String getTargetModel(ActionBuilderLine line) {
        MetaField field;
        MetaJsonField jsonField = line.getMetaJsonField();
        String targetModel = "";
        if (jsonField != null && jsonField.getTargetModel() != null) {
            targetModel = jsonField.getTargetModel();
        }
        if ((field = line.getMetaField()) != null && field.getTypeName() != null) {
            targetModel = field.getTypeName();
        }
        return targetModel;
    }

    private String getTargetJsonModel(ActionBuilderLine line) {
        MetaJsonField jsonField = line.getMetaJsonField();
        if (jsonField != null) {
            return jsonField.getTargetJsonModel().getName();
        }
        return "";
    }

    private String getRootSourceModel(ActionBuilderLine line) {
        if (line.getActionBuilder() != null) {
            return line.getActionBuilder().getModel();
        }
        return null;
    }

    private String getSourceModel(ActionBuilderLine line) {
        MetaJsonField jsonField = line.getValueJson();
        String sourceModel = null;
        Object targetObject = null;
        try {
            MetaField field;
            if (jsonField != null && jsonField.getTargetModel() != null) {
                if (line.getValue() != null && !line.getValue().contentEquals("$." + jsonField.getName())) {
                    targetObject = this.filterSqlService.parseJsonField(jsonField, line.getValue().replace("$.", ""), null, null);
                } else {
                    sourceModel = jsonField.getTargetModel();
                }
            }
            if ((field = line.getValueField()) != null && field.getTypeName() != null) {
                if (line.getValue() != null && !line.getValue().contentEquals("$." + field.getName())) {
                    targetObject = this.filterSqlService.parseMetaField(field, line.getValue().replace("$.", ""), null, null, false);
                } else {
                    sourceModel = field.getTypeName();
                }
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)e);
        }
        if (sourceModel == null && line.getValue() != null && line.getValue().equals("$")) {
            sourceModel = this.getRootSourceModel(line);
        }
        if (sourceModel == null && line.getValue() != null && line.getValue().equals("$$")) {
            sourceModel = this.getRootSourceModel(line);
        }
        if (targetObject != null) {
            if (targetObject instanceof MetaJsonField) {
                sourceModel = ((MetaJsonField)((Object)targetObject)).getTargetModel();
            } else if (targetObject instanceof MetaField) {
                sourceModel = ((MetaField)targetObject).getTypeName();
            }
        }
        return sourceModel;
    }

    private String addM2OBinding(ActionBuilderLine line, boolean search, boolean filter) {
        List<ActionBuilderLine> lines;
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        String tModel = this.getTargetModel(line);
        String srcModel = this.getSourceModel(line);
        StringBuilder stb = new StringBuilder();
        this.fbuilder.add(stb);
        if (tModel.contains(".")) {
            tModel = tModel.substring(tModel.lastIndexOf(46) + 1);
        }
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "($$, $, _$){", 1));
        stb.append(this.format("var val = null;", 2));
        if (srcModel != null) {
            stb.append(this.format("if ($ != null && $.id != null){", 2));
            srcModel = srcModel.substring(srcModel.lastIndexOf(46) + 1);
            stb.append(this.format("$ = $em.find(" + srcModel + ".class, $.id);", 3));
            this.log.debug("src model: {}, Target model: {}", (Object)srcModel, (Object)tModel);
            if (srcModel.contentEquals(tModel)) {
                stb.append(this.format("val = $", 3));
            }
            stb.append(this.format("}", 2));
        }
        if (filter && line.getFilter() != null) {
            if (line.getValue() != null) {
                stb.append(this.format("var map = com.axelor.db.mapper.Mapper.toMap($);", 2));
            } else {
                stb.append(this.format("var map = com.axelor.db.mapper.Mapper.toMap($$);", 2));
            }
            stb.append(this.format("val = " + this.getQuery(tModel, line.getFilter(), false, false), 2));
        }
        if ((lines = line.getSubLines()) != null && !lines.isEmpty()) {
            stb.append(this.format("if (!val) {", 2));
            stb.append(this.format("val = new " + tModel + "();", 3));
            stb.append(this.format("}", 2));
            stb.append(this.addFieldsBinding("val", lines, 2));
        }
        stb.append(this.format("return val;", 2));
        stb.append(this.format("}", 1));
        return fname;
    }

    private String addM2MBinding(ActionBuilderLine line) {
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        StringBuilder stb = new StringBuilder();
        this.fbuilder.add(stb);
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "($$, $, _$){", 1));
        stb.append(this.format("var val  = new HashSet();", 2));
        if (line.getFilter() != null) {
            String model = this.getTargetModel(line);
            stb.append(this.format("var map = com.axelor.db.mapper.Mapper.toMap($$);", 2));
            stb.append(this.format("val.addAll(" + this.getQuery(model, line.getFilter(), false, true) + ");", 2));
            stb.append(this.format("if(!val.empty){return val;}", 2));
        }
        stb.append(this.format("if(!$){return val;}", 2));
        stb.append(this.format("$.forEach(function(v){", 2));
        stb.append(this.format("v = " + this.addM2OBinding(line, true, false) + "($$, v, _$);", 3));
        stb.append(this.format("val.add(v);", 3));
        stb.append(this.format("})", 2));
        stb.append(this.format("return val;", 2));
        stb.append(this.format("}", 1));
        return fname;
    }

    private String addO2MBinding(ActionBuilderLine line, String target) {
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        StringBuilder stb = new StringBuilder();
        this.fbuilder.add(stb);
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "($$, $, _$){", 1));
        stb.append(this.format("var val  = new ArrayList();", 2));
        stb.append(this.format("if(!$){return val;}", 2));
        stb.append(this.format("$.forEach(function(v){", 2));
        stb.append(this.format("var item = " + this.addM2OBinding(line, false, false) + "($$, v, _$);", 3));
        if (this.isCreate && line.getMetaField() != null && line.getMetaField().getMappedBy() != null) {
            stb.append(this.format("item." + line.getMetaField().getMappedBy() + " = " + target, 3));
        }
        stb.append(this.format("val.add(item);", 3));
        stb.append(this.format("})", 2));
        stb.append(this.format("return val;", 2));
        stb.append(this.format("}", 1));
        return fname;
    }

    private String addJsonM2OBinding(ActionBuilderLine line, boolean search, boolean filter) {
        List<ActionBuilderLine> lines;
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        StringBuilder stb = new StringBuilder();
        this.fbuilder.add(stb);
        String model = this.getTargetJsonModel(line);
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "($$, $, _$){", 1));
        stb.append(this.format("var val = null;", 2));
        if (search) {
            stb.append(this.format("if ($ != null && $.id != null) {", 2));
            stb.append(this.format("val = $json.find($.id);", 3));
            stb.append(this.format("if (val.jsonModel != '" + model + "'){val = null;} ", 3));
            stb.append(this.format("}", 2));
        }
        if (filter && line.getFilter() != null) {
            String query = this.getQuery(model, line.getFilter(), true, false);
            stb.append(this.format("val = " + query, 2));
        }
        if ((lines = line.getSubLines()) != null && !lines.isEmpty()) {
            stb.append(this.format("if (!val) {", 2));
            stb.append(this.format("val = $json.create('" + model + "');", 3));
            stb.append(this.format("}", 2));
            stb.append(this.format("else {", 2));
            stb.append(this.format("val = $json.create(val);", 3));
            stb.append(this.format("}", 2));
            stb.append(this.addFieldsBinding("val", lines, 2));
            stb.append(this.format("val = $json.save(val);", 2));
        }
        stb.append(this.format("return val;", 2));
        stb.append(this.format("}", 1));
        return fname;
    }

    private String addJsonM2MBinding(ActionBuilderLine line) {
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        StringBuilder stb = new StringBuilder();
        this.fbuilder.add(stb);
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "($$, $, _$){", 1));
        stb.append(this.format("var val  = new HashSet();", 2));
        if (line.getFilter() != null) {
            String model = this.getTargetJsonModel(line);
            stb.append(this.format("val.addAll(" + this.getQuery(model, line.getFilter(), true, true) + ");", 2));
            stb.append(this.format("if(!val.empty){return val;}", 2));
        }
        stb.append(this.format("if(!$){return val;}", 2));
        stb.append(this.format("$.forEach(function(v){", 2));
        stb.append(this.format("v = " + this.addJsonM2OBinding(line, true, false) + "($$, v, _$);", 3));
        stb.append(this.format("val.add(v);", 3));
        stb.append(this.format("})", 2));
        stb.append(this.format("return val;", 2));
        stb.append(this.format("}", 1));
        return fname;
    }

    private String addJsonO2MBinding(ActionBuilderLine line) {
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        StringBuilder stb = new StringBuilder();
        this.fbuilder.add(stb);
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "($$, $, _$){", 1));
        stb.append(this.format("var val  = new ArrayList();", 2));
        stb.append(this.format("if(!$){return val;}", 2));
        stb.append(this.format("$.forEach(function(v){", 2));
        stb.append(this.format("v = " + this.addJsonM2OBinding(line, false, false) + "($$, v, _$);", 3));
        stb.append(this.format("val.add(v);", 3));
        stb.append(this.format("})", 2));
        stb.append(this.format("return val;", 2));
        stb.append(this.format("}", 1));
        return fname;
    }

    private String getQuery(String model, String filter, boolean json, boolean all) {
        if (model.contains(".")) {
            model = model.substring(model.lastIndexOf(46) + 1);
        }
        String nRecords = "fetchOne()";
        if (all) {
            nRecords = "fetch()";
        }
        String query = null;
        query = json ? "$json.all('" + model + "').by(" + filter + ")." + nRecords : "__repo__(" + model + ".class).all().filter(\"" + filter + "\").bind(map).bind(_$)." + nRecords;
        return query;
    }

    private String getSum(String value, String filter) {
        value = value.substring(0, value.length() - 1);
        String[] expr = value.split("\\.sum\\(");
        String fname = "setVar" + this.varCount;
        ++this.varCount;
        StringBuilder stb = new StringBuilder();
        stb.append(this.format("", 1));
        stb.append(this.format("function " + fname + "(sumOf$, $$, filter){", 1));
        stb.append(this.format("var val  = 0", 2));
        stb.append(this.format("if (sumOf$ == null){ return val;}", 2));
        stb.append(this.format("sumOf$.forEach(function($){", 2));
        String val = "val += " + expr[1] + ";";
        if (filter != null) {
            val = "if(filter){" + val + "}";
        }
        stb.append(this.format(val, 3));
        stb.append(this.format("})", 2));
        stb.append(this.format("return new BigDecimal(val);", 2));
        stb.append(this.format("}", 1));
        this.fbuilder.add(stb);
        return fname + "(" + expr[0] + ",$," + filter + ")";
    }
}

