/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.common.StringUtils;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.ActionBuilderLine;
import com.axelor.studio.db.ActionBuilderView;
import com.axelor.studio.service.StudioMetaService;
import com.google.inject.Inject;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class ActionViewBuilderService {
    private static final String INDENT = "\t";
    @Inject
    private StudioMetaService metaService;

    public MetaAction build(ActionBuilder builder) {
        if (builder == null) {
            return null;
        }
        List<ActionBuilderView> views = builder.getActionBuilderViews();
        if (views == null || views.isEmpty()) {
            return null;
        }
        StringBuilder xml = new StringBuilder();
        String model = this.appendBasic(builder, xml);
        this.appendViews(views, xml);
        this.appendParams(builder.getViewParams(), xml);
        this.appendDomain(builder.getDomainCondition(), builder.getIsJson(), xml);
        this.appendContext(builder, xml);
        xml.append("\n</action-view>");
        return this.metaService.updateMetaAction(builder.getName(), "action-view", xml.toString(), model);
    }

    private void appendParams(List<ActionBuilderLine> params, StringBuilder xml) {
        if (params == null) {
            return;
        }
        for (ActionBuilderLine param : params) {
            xml.append("\n\t<view-param name=\"" + param.getName() + "\" ");
            xml.append("value=\"" + StringEscapeUtils.escapeXml((String)param.getValue()) + "\" />");
        }
    }

    private void appendContext(ActionBuilder builder, StringBuilder xml) {
        boolean addJsonCtx = true;
        if (builder.getLines() != null) {
            for (ActionBuilderLine context : builder.getLines()) {
                if (context.getName().contentEquals("jsonModel")) {
                    addJsonCtx = false;
                }
                xml.append("\n\t<context name=\"" + context.getName() + "\" ");
                xml.append("expr=\"eval:" + StringEscapeUtils.escapeXml((String)context.getValue()) + "\" />");
            }
        }
        if (addJsonCtx && builder.getIsJson().booleanValue() && builder.getModel() != null) {
            xml.append("\n\t<context name=\"jsonModel\" ");
            xml.append("expr=\"" + builder.getModel() + "\" />");
        }
    }

    private void appendDomain(String domain, Boolean isJson, StringBuilder xml) {
        if (isJson.booleanValue()) {
            String jsonDomain = "self.jsonModel = :jsonModel";
            if (domain == null) {
                domain = jsonDomain;
            } else if (!domain.contains(jsonDomain)) {
                domain = jsonDomain + " AND (" + domain + ")";
            }
        }
        if (domain != null) {
            xml.append("\n\t<domain>" + StringEscapeUtils.escapeXml((String)domain) + "</domain>");
        }
    }

    private void appendViews(List<ActionBuilderView> views, StringBuilder xml) {
        views.sort((action1, action2) -> action1.getSequence().compareTo(action2.getSequence()));
        for (ActionBuilderView view : views) {
            xml.append("\n\t<view type=\"" + view.getViewType() + "\" ");
            xml.append("name=\"" + view.getViewName() + "\" ");
            if (StringUtils.notEmpty((CharSequence)view.getViewConditionToCheck())) {
                xml.append("if=\"" + view.getViewConditionToCheck() + "\" />");
                continue;
            }
            xml.append("/>");
        }
    }

    private String appendBasic(ActionBuilder builder, StringBuilder xml) {
        xml.append("<action-view name=\"" + builder.getName() + "\" ");
        xml.append("title=\"" + builder.getTitle() + "\" ");
        xml.append("id=\"studio-" + builder.getName() + "\" ");
        String model = MetaJsonRecord.class.getName();
        if (!builder.getIsJson().booleanValue()) {
            model = builder.getModel();
        }
        xml.append("model=\"" + model + "\">");
        return model;
    }
}

