/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.repo.AppRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.studio.db.AppBuilder;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.HashSet;

public class AppBuilderService {
    @Inject
    private AppRepository appRepo;

    public AppBuilder build(AppBuilder appBuilder) throws AxelorException {
        this.checkCode(appBuilder);
        App app = appBuilder.getGeneratedApp();
        if (app == null) {
            app = new App(appBuilder.getName(), appBuilder.getCode());
        } else {
            app.setCode(appBuilder.getCode());
            app.setName(appBuilder.getName());
        }
        app.setImage(appBuilder.getImage());
        app.setDescription(appBuilder.getDescription());
        HashSet<App> depends = new HashSet<App>();
        if (appBuilder.getDependsOnSet() != null) {
            depends.addAll(appBuilder.getDependsOnSet());
            app.setDependsOnSet(depends);
        }
        app.setSequence(appBuilder.getSequence());
        app.setInitDataLoaded(Boolean.valueOf(true));
        app.setDemoDataLoaded(Boolean.valueOf(true));
        appBuilder.setGeneratedApp((App)this.appRepo.save((Model)app));
        return appBuilder;
    }

    private void checkCode(AppBuilder appBuilder) throws AxelorException {
        App app = this.appRepo.findByCode(appBuilder.getCode());
        if (app != null && app != appBuilder.getGeneratedApp()) {
            throw new AxelorException(5, I18n.get((String)"Please provide unique code. The code '%s' is already used"), new Object[]{appBuilder.getCode()});
        }
    }

    @Transactional
    public void clean(AppBuilder appBuilder) {
        if (appBuilder.getGeneratedApp() != null) {
            this.appRepo.remove((Model)appBuilder.getGeneratedApp());
            appBuilder.setGeneratedApp(null);
        }
    }
}

