/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.common.Inflector;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.CallMethod;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.studio.db.ChartBuilder;
import com.axelor.studio.db.Filter;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.filter.FilterCommonService;
import com.axelor.studio.service.filter.FilterSqlService;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartBuilderService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String Tab1 = "\n \t";
    private static final String Tab2 = "\n \t\t";
    private static final String Tab3 = "\n \t\t\t";
    private static final List<String> dateTypes = Arrays.asList("DATE", "DATETIME", "LOCALDATE", "LOCALDATETIME", "ZONNEDDATETIME");
    private List<String> searchFields;
    private List<String> joins;
    private String categType;
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    private FilterSqlService filterSqlService;
    @Inject
    private FilterCommonService filterCommonService;
    @Inject
    private StudioMetaService metaService;

    public void build(ChartBuilder chartBuilder) throws JAXBException, AxelorException {
        if (chartBuilder.getName().contains(" ")) {
            throw new AxelorException(1, I18n.get((String)"Name must not contains space"));
        }
        this.searchFields = new ArrayList<String>();
        this.joins = new ArrayList<String>();
        this.categType = "text";
        String[] queryString = this.prepareQuery(chartBuilder);
        String xml = this.createXml(chartBuilder, queryString);
        this.log.debug("Chart xml: {}", (Object)xml);
        ObjectViews chartView = XMLViews.fromXML((String)xml);
        MetaView metaView = this.metaService.generateMetaView((AbstractView)chartView.getViews().get(0));
        if (metaView != null) {
            chartBuilder.setMetaViewGenerated(metaView);
        }
    }

    private String createXml(ChartBuilder chartBuilder, String[] queryString) {
        String xml = "<chart name=\"" + chartBuilder.getName() + "\" title=\"" + chartBuilder.getTitle() + "\" ";
        xml = xml + ">\n";
        if (!this.searchFields.isEmpty()) {
            xml = xml + "\t" + this.getSearchFields() + "\n";
        }
        String groupLabel = chartBuilder.getIsJsonGroupOn() != false ? chartBuilder.getGroupOnJson().getTitle() : chartBuilder.getGroupOn().getLabel();
        String displayLabel = chartBuilder.getIsJsonDisplayField() != false ? chartBuilder.getDisplayFieldJson().getTitle() : chartBuilder.getDisplayField().getLabel();
        xml = xml + "\t<dataset type=\"sql\"><![CDATA[";
        xml = xml + Tab2 + queryString[0];
        xml = xml + "\n \t\t ]]></dataset>";
        xml = xml + "\n \t<category key=\"group_field\" type=\"" + this.categType + "\" title=\"" + groupLabel + "\" />";
        xml = xml + "\n \t<series key=\"sum_field\" type=\"" + chartBuilder.getChartType() + "\" title=\"" + displayLabel + "\" ";
        if (queryString[1] != null) {
            xml = xml + "groupBy=\"agg_field\" ";
        }
        xml = xml + "/>\n";
        xml = xml + "</chart>";
        return xml;
    }

    private String[] prepareQuery(ChartBuilder chartBuilder) throws AxelorException {
        String query = this.createSumQuery(chartBuilder.getIsJsonDisplayField(), chartBuilder.getDisplayField(), chartBuilder.getDisplayFieldJson());
        String groupField = this.getGroup(chartBuilder.getIsJsonGroupOn(), chartBuilder.getGroupOn(), chartBuilder.getGroupOnJson(), chartBuilder.getGroupDateType(), chartBuilder.getGroupOnTarget());
        String aggField = this.getGroup(chartBuilder.getIsJsonAggregateOn(), chartBuilder.getAggregateOn(), chartBuilder.getAggregateOnJson(), chartBuilder.getAggregateDateType(), chartBuilder.getAggregateOnTarget());
        query = query + groupField + " AS group_field";
        if (aggField != null) {
            query = query + ",\n \t\t\t" + aggField + " AS agg_field";
        }
        String filters = this.filterSqlService.getSqlFilters(chartBuilder.getFilterList(), this.joins, true);
        this.addSearchField(chartBuilder.getFilterList());
        String model = chartBuilder.getModel();
        if (chartBuilder.getIsJson().booleanValue()) {
            filters = filters != null ? "self.json_model = '" + model + "' AND (" + filters + ")" : "self.json_model = '" + model + "'";
            model = MetaJsonRecord.class.getName();
        }
        query = query + "\n \t\tFROM \n \t\t\t" + this.getTable(model) + " self";
        if (!this.joins.isEmpty()) {
            query = query + Tab3 + Joiner.on((String)Tab3).join(this.joins);
        }
        if (filters != null) {
            query = query + "\n \t\tWHERE \n \t\t\t" + filters;
        }
        query = query + "\n \t\tgroup by \n \t\t\tgroup_field";
        if (aggField != null && aggField != null) {
            query = query + ",agg_field";
            return new String[]{query, aggField};
        }
        return new String[]{query, null};
    }

    private String createSumQuery(boolean isJson, MetaField metaField, MetaJsonField jsonField) {
        String sumField = null;
        if (isJson) {
            String sqlType = this.filterSqlService.getSqlType(jsonField.getType());
            sumField = "cast(self." + this.filterSqlService.getColumn(jsonField.getModel(), jsonField.getModelField()) + "->>'" + jsonField.getName() + "' as " + sqlType + ")";
        } else {
            sumField = "self." + this.filterSqlService.getColumn(metaField);
        }
        return "SELECT\n \t\t\tSUM(" + sumField + ") AS sum_field," + Tab3;
    }

    private String getGroup(boolean isJson, MetaField metaField, MetaJsonField jsonField, String dateType, String target) throws AxelorException {
        if (!isJson && metaField == null || isJson && jsonField == null) {
            return null;
        }
        String typeName = null;
        String group = null;
        Object object = null;
        StringBuilder parent = new StringBuilder("self");
        if (isJson) {
            group = jsonField.getName();
            typeName = this.filterSqlService.getSqlType(jsonField.getType());
            if (target != null) {
                object = this.filterSqlService.parseJsonField(jsonField, target, this.joins, parent);
            }
        } else {
            group = this.filterSqlService.getColumn(metaField);
            typeName = this.filterSqlService.getSqlType(metaField.getTypeName());
            if (target != null) {
                object = this.filterSqlService.parseMetaField(metaField, target, this.joins, parent, true);
            }
        }
        if (object != null) {
            String[] sqlField = this.filterSqlService.getSqlField(object, parent.toString(), this.joins);
            typeName = sqlField[1];
            group = sqlField[0];
        }
        this.log.debug("Group field type: {}, group: {}, dateType: {}", new Object[]{typeName, group, dateType});
        if (dateType != null && typeName != null && dateTypes.contains(typeName.toUpperCase())) {
            group = this.getDateTypeGroup(dateType, typeName, group);
        }
        return group;
    }

    private String getDateTypeGroup(String dateType, String typeName, String group) {
        switch (dateType) {
            case "year": {
                group = "to_char(cast(" + group + " as date), 'yyyy')";
                break;
            }
            case "month": {
                group = "to_char(cast(" + group + " as date), 'yyyy-mm')";
                break;
            }
            default: {
                this.categType = "date";
            }
        }
        return group;
    }

    private String getSearchFields() {
        String search = "<search-fields>";
        for (String searchField : this.searchFields) {
            search = search + Tab2 + searchField;
        }
        search = search + "\n \t</search-fields>";
        return search;
    }

    private void addSearchField(List<Filter> filters) throws AxelorException {
        if (filters == null) {
            return;
        }
        for (Filter filter : filters) {
            if (!filter.getIsParameter().booleanValue()) continue;
            String fieldStr = "param" + filter.getId();
            Object object = null;
            StringBuilder parent = new StringBuilder("self");
            object = filter.getIsJson() != false ? this.filterSqlService.parseJsonField(filter.getMetaJsonField(), filter.getTargetField(), null, parent) : this.filterSqlService.parseMetaField(filter.getMetaField(), filter.getTargetField(), null, parent, true);
            fieldStr = object instanceof MetaField ? this.getMetaSearchField(fieldStr, (MetaField)object) : this.getJsonSearchField(fieldStr, (MetaJsonField)((Object)object));
            this.searchFields.add(fieldStr + "\" x-required=\"true\" />");
        }
    }

    private String getMetaSearchField(String fieldStr, MetaField field) {
        fieldStr = "<field name=\"" + fieldStr + "\" title=\"" + field.getLabel();
        if (field.getRelationship() == null) {
            String fieldType = this.filterCommonService.getFieldType(field);
            fieldStr = fieldStr + "\" type=\"" + fieldType;
        } else {
            String[] targetRef = this.filterSqlService.getDefaultTarget(field.getName(), field.getTypeName());
            String[] nameField = targetRef[0].split("\\.");
            fieldStr = fieldStr + "\" widget=\"ref-text\" type=\"" + this.filterCommonService.getFieldType(targetRef[1]) + "\" x-target-name=\"" + nameField[1] + "\" x-target=\"" + this.metaModelRepo.findByName(field.getTypeName()).getFullName();
        }
        return fieldStr;
    }

    private String getJsonSearchField(String fieldStr, MetaJsonField field) {
        fieldStr = "<field name=\"" + fieldStr + "\" title=\"" + field.getTitle();
        if (field.getTargetJsonModel() != null) {
            String[] targetRef = this.filterSqlService.getDefaultTargetJson(field.getName(), field.getTargetJsonModel());
            String[] nameField = targetRef[0].split("\\.");
            fieldStr = fieldStr + "\" widget=\"ref-text\" type=\"" + this.filterCommonService.getFieldType(targetRef[1]) + "\" x-target-name=\"" + nameField[1] + "\" x-target=\"" + MetaJsonRecord.class.getName() + "\" x-domain=\"self.jsonModel = '" + field.getTargetJsonModel().getName() + "'";
        } else if (field.getTargetModel() != null) {
            String[] targetRef = this.filterSqlService.getDefaultTarget(field.getName(), field.getTargetModel());
            String[] nameField = targetRef[0].split("\\.");
            fieldStr = fieldStr + "\" widget=\"ref-text\" type=\"" + this.filterCommonService.getFieldType(targetRef[1]) + "\" x-target-name=\"" + nameField[1] + "\" x-target=\"" + field.getTargetModel();
        } else {
            String fieldType = Inflector.getInstance().camelize(field.getType(), true);
            fieldStr = fieldStr + "\" type=\"" + fieldType;
        }
        return fieldStr;
    }

    private String getTable(String model) {
        String[] models = model.split("\\.");
        MetaModel metaModel = this.metaModelRepo.findByName(models[models.length - 1]);
        if (metaModel != null) {
            return metaModel.getTableName();
        }
        return null;
    }

    @CallMethod
    public String getDefaultTarget(MetaField metaField) {
        if (metaField.getRelationship() == null) {
            return metaField.getName();
        }
        return this.filterSqlService.getDefaultTarget(metaField.getName(), metaField.getTypeName())[0];
    }

    @CallMethod
    public String getDefaultTarget(MetaJsonField metaJsonField) {
        if (!"many-to-one,one-to-one,json-many-to-one".contains(metaJsonField.getType())) {
            return metaJsonField.getName();
        }
        if (metaJsonField.getTargetJsonModel() != null) {
            return this.filterSqlService.getDefaultTargetJson(metaJsonField.getName(), metaJsonField.getTargetJsonModel())[0];
        }
        if (metaJsonField.getTargetModel() == null) {
            return metaJsonField.getName();
        }
        return this.filterSqlService.getDefaultTarget(metaJsonField.getName(), metaJsonField.getTargetModel())[0];
    }

    @CallMethod
    public String getTargetType(Object object, String target) {
        if (target == null) {
            this.log.debug("No target provided for target type");
            return null;
        }
        Object targetField = null;
        try {
            if (object instanceof MetaJsonField) {
                targetField = this.filterSqlService.parseJsonField((MetaJsonField)((Object)object), target, null, null);
            } else if (object instanceof MetaField) {
                targetField = this.filterSqlService.parseMetaField((MetaField)object, target, null, null, true);
            }
        }
        catch (AxelorException axelorException) {
            // empty catch block
        }
        if (targetField == null) {
            this.log.debug("Target field not found");
            return null;
        }
        this.log.debug("Target field found: {}", targetField);
        return this.filterSqlService.getTargetType(targetField);
    }
}

