/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.common.Inflector;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Field;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.GridView;
import com.axelor.meta.schema.views.Panel;
import com.axelor.meta.schema.views.PanelField;
import com.axelor.meta.schema.views.PanelRelated;
import com.axelor.meta.schema.views.PanelTabs;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportBuilderService {
    private Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<String[]> panels;
    private List<String[]> sidePanels;
    private String model;
    private String template;
    private Inflector inflector;
    @Inject
    private MetaFieldRepository metaFieldRepo;
    @Inject
    private MetaViewRepository metaViewRepo;
    @Inject
    private MetaModelRepository metaModelRepo;

    public String generateTemplate(MetaView metaView) {
        this.panels = new ArrayList<String[]>();
        this.sidePanels = new ArrayList<String[]>();
        this.model = metaView.getModel();
        this.template = "";
        this.inflector = Inflector.getInstance();
        try {
            this.processView(metaView.getXml());
            this.generateHtml(false);
            this.generateHtml(true);
            this.template = "<table class=\"table no-border\"><tr>" + this.template + "</tr></table>";
            this.log.debug("Template generated: {}", (Object)this.template);
            return this.template;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void processView(String xml) throws JAXBException {
        ObjectViews objectViews = XMLViews.fromXML((String)xml);
        AbstractView view = (AbstractView)objectViews.getViews().get(0);
        FormView formView = (FormView)view;
        for (AbstractWidget widget : formView.getItems()) {
            if (widget instanceof PanelTabs) {
                PanelTabs panelTabs = (PanelTabs)widget;
                AbstractWidget tabItem = (AbstractWidget)panelTabs.getItems().get(0);
                this.processAbstractWidget(tabItem, false);
                continue;
            }
            this.processAbstractWidget(widget, false);
        }
    }

    private void processAbstractWidget(AbstractWidget widget, Boolean sidePanel) {
        if (widget instanceof Panel) {
            this.processPanel((Panel)widget, sidePanel);
        } else if (widget instanceof PanelRelated) {
            PanelRelated panelRelated = (PanelRelated)widget;
            sidePanel = sidePanel != null && sidePanel != false ? sidePanel : panelRelated.getSidebar();
            this.processPanelRelated(panelRelated, sidePanel, "12");
        } else if (widget instanceof PanelField) {
            this.processField((PanelField)widget, sidePanel);
        }
    }

    private void processPanel(Panel panel, Boolean sidePanel) {
        sidePanel = sidePanel != null && sidePanel != false ? sidePanel : panel.getSidebar();
        String title = panel.getTitle();
        if (title != null) {
            title = "<td><h4><u>" + title + "</u></h4></td>";
            if (sidePanel != null && sidePanel.booleanValue()) {
                this.sidePanels.add(new String[]{"12", title});
            } else {
                this.panels.add(new String[]{"12", title});
            }
        }
        for (AbstractWidget widget : panel.getItems()) {
            this.processAbstractWidget(widget, sidePanel);
        }
    }

    private void processField(PanelField field, Boolean sidePanel) {
        String title = field.getTitle();
        String name = field.getName();
        MetaField metaField = this.getMetaField(name, this.model);
        if (Strings.isNullOrEmpty((String)title)) {
            title = this.getFieldTitle(name, metaField);
        }
        name = this.processRelational(name, metaField);
        String value = "<td><b>" + title + "</b> : $" + name + "$</td>";
        String colSpan = "6";
        if (field.getColSpan() != null && field.getColSpan() == 12) {
            colSpan = "12";
            value = "<td colSpan=\"2\"><b>" + title + "</b> : $" + name + "$</td>";
        } else {
            value = "<td><b>" + title + "</b> : $" + name + "$</td>";
        }
        if (sidePanel != null && sidePanel.booleanValue()) {
            this.sidePanels.add(new String[]{"12", value});
        } else {
            this.panels.add(new String[]{colSpan, value});
        }
    }

    private String processRelational(String name, MetaField metaField) {
        if (metaField == null) {
            return name;
        }
        String relationship = metaField.getRelationship();
        if (relationship == null) {
            return name;
        }
        String nameColumn = this.getNameColumn(name, metaField);
        if (!relationship.equals("ManyToOne")) {
            String[] names = nameColumn.split("\\.");
            nameColumn = name + " : {item | $item." + names[1] + "$ }";
        }
        return nameColumn;
    }

    private String getNameColumn(String name, MetaField metaField) {
        String refModel = this.getRefModel(metaField.getTypeName());
        try {
            Mapper mapper = Mapper.of(Class.forName(refModel));
            boolean nameField = false;
            boolean codeField = false;
            for (Property property : Arrays.asList(mapper.getProperties())) {
                if (property.isNameColumn()) {
                    return name + "." + property.getName();
                }
                if (property.getName().equals("name")) {
                    nameField = true;
                    continue;
                }
                if (!property.getName().equals("code")) continue;
                codeField = true;
            }
            if (nameField) {
                return name + ".name";
            }
            if (codeField) {
                return name + ".code";
            }
            return name + ".id";
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return name;
        }
    }

    private void generateHtml(boolean sidePanel) {
        List<String[]> panelList;
        List<String[]> list = panelList = sidePanel ? this.sidePanels : this.panels;
        if (panelList.isEmpty()) {
            return;
        }
        this.template = this.template + "<td><table>";
        int totalSpan = 0;
        for (String[] field : panelList) {
            int colSpan = Integer.parseInt(field[0]);
            if (colSpan == 12) {
                if (totalSpan > 0) {
                    totalSpan = 0;
                    this.template = this.template + "</tr>";
                }
                this.template = this.template + "<tr>" + field[1] + "</tr>";
                continue;
            }
            if (totalSpan == 0) {
                this.template = this.template + "<tr>";
            }
            this.template = this.template + field[1];
            if ((totalSpan += colSpan) != 12) continue;
            totalSpan = 0;
            this.template = this.template + "</tr>";
        }
        if (totalSpan > 0) {
            this.template = this.template + "</tr>";
        }
        this.template = this.template + "</table></td>";
    }

    private String getFieldTitle(String name, MetaField metaField) {
        String title;
        this.log.debug("Meta field for name : {}, metaField: {}", (Object)name, (Object)metaField);
        if (metaField != null && !Strings.isNullOrEmpty((String)(title = metaField.getLabel()))) {
            return metaField.getLabel();
        }
        return this.inflector.humanize(name);
    }

    private MetaField getMetaField(String name, String modelName) {
        MetaField metaField = (MetaField)this.metaFieldRepo.all().filter("self.name = ? AND self.metaModel.fullName = ?", new Object[]{name, modelName}).fetchOne();
        return metaField;
    }

    public void processPanelRelated(PanelRelated panelRelated, Boolean sidePanel, String colSpan) {
        String title = panelRelated.getTitle();
        String name = panelRelated.getName();
        MetaField metaField = this.getMetaField(name, this.model);
        if (Strings.isNullOrEmpty((String)title) && metaField != null) {
            title = metaField.getLabel();
        }
        if (Strings.isNullOrEmpty((String)title)) {
            title = this.inflector.humanize(name);
        }
        String field = "<td colSpan=\"2\"><h4>" + title + "</h4></td>";
        String refModel = this.getRefModel(metaField.getTypeName());
        String itemTable = this.createTable(panelRelated, refModel);
        if (sidePanel != null && sidePanel.booleanValue()) {
            this.sidePanels.add(new String[]{"12", field});
            this.sidePanels.add(new String[]{"12", itemTable});
        } else {
            this.panels.add(new String[]{colSpan, field});
            this.panels.add(new String[]{colSpan, itemTable});
        }
    }

    private String createTable(PanelRelated panelRelated, String refModel) {
        List items = panelRelated.getItems();
        if (items != null && !items.isEmpty()) {
            return this.getHtmlTable(panelRelated.getName(), items, refModel);
        }
        MetaView gridView = this.findGridView(panelRelated.getGridView(), refModel);
        if (gridView != null) {
            try {
                ObjectViews views = XMLViews.fromXML((String)gridView.getXml());
                GridView grid = (GridView)views.getViews().get(0);
                return this.getHtmlTable(panelRelated.getName(), grid.getItems(), refModel);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String getHtmlTable(String fieldName, List<AbstractWidget> widgets, String refModel) {
        String header = "";
        String row = "";
        for (AbstractWidget widget : widgets) {
            if (!(widget instanceof Field)) continue;
            Field field = (Field)widget;
            String name = field.getName();
            String title = field.getTitle();
            MetaField metaField = this.getMetaField(name, refModel);
            if (Strings.isNullOrEmpty((String)title)) {
                title = this.getFieldTitle(name, metaField);
            }
            name = this.processRelational(name, metaField);
            header = header + "<th>" + title + "</th>";
            row = row + "<td>$" + fieldName + "." + name + "$</td>";
        }
        String table = "<td colSpan=\"2\"><table class=\"table table-bordered table-header\"><tr>" + header + "</tr><tr>" + row + "</tr></table></td>";
        return table;
    }

    private MetaView findGridView(String gridName, String refModel) {
        MetaView gridView = null;
        if (gridName != null) {
            gridView = this.metaViewRepo.findByName(gridName);
        }
        if (gridView == null) {
            gridView = (MetaView)this.metaViewRepo.all().filter("self.type = 'grid' and self.model = ?", new Object[]{refModel}).fetchOne();
        }
        return gridView;
    }

    private String getRefModel(String refModel) {
        MetaModel metaModel = this.metaModelRepo.findByName(refModel);
        if (metaModel != null) {
            refModel = metaModel.getFullName();
        }
        return refModel;
    }
}

