/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.builder;

import com.axelor.db.Model;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.meta.schema.views.Selection;
import com.axelor.studio.db.SelectionBuilder;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectionBuilderService {
    @Inject
    private MetaSelectRepository metaSelectRepository;
    public static final String SELECTION_PREFIX = "custom-selection-builder-";

    public String createSelectionText(String selectionName) {
        List options = MetaStore.getSelectionList((String)selectionName);
        boolean allSame = true;
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> valuesWithTitles = new ArrayList<String>();
        for (Selection.Option option : options) {
            if (option.getHidden() != null && option.getHidden().booleanValue()) continue;
            valuesWithTitles.add(option.getValue() + ":" + option.getTitle());
            if (allSame && !option.getValue().equals(option.getTitle())) {
                allSame = false;
                continue;
            }
            values.add(option.getValue());
        }
        return Joiner.on((String)"\n").join(allSame ? values : valuesWithTitles);
    }

    @Transactional
    public void removeSelection(String name, String xmlId) {
        MetaSelect metaSelect;
        if (name == null && xmlId == null) {
            return;
        }
        MetaSelect metaSelect2 = metaSelect = xmlId != null ? this.findMetaSelectById(xmlId) : this.findMetaSelectByName(name);
        if (metaSelect != null) {
            this.metaSelectRepository.remove((Model)((Object)metaSelect));
        }
    }

    public void build(SelectionBuilder selectionBuilder) {
        String xmlId = SELECTION_PREFIX + selectionBuilder.getId();
        this.updateMetaSelectFromText(selectionBuilder.getSelectionText(), selectionBuilder.getName(), xmlId);
    }

    @Transactional
    public String updateMetaSelectFromText(String selectionText, String name, String xmlId) {
        if (name == null && xmlId == null) {
            return null;
        }
        MetaSelect metaSelect = this.updateSelectItems(selectionText, name, xmlId);
        metaSelect.setIsCustom(true);
        metaSelect.setName(name);
        if (xmlId != null) {
            Integer priority = this.getPriority(name, xmlId);
            if (priority != null) {
                metaSelect.setPriority(priority);
            }
            metaSelect.setXmlId(xmlId);
        }
        this.metaSelectRepository.save((Model)((Object)metaSelect));
        return name;
    }

    private MetaSelect updateSelectItems(String selectionText, String name, String xmlId) {
        String[] selection = selectionText.split("\n");
        MetaSelect metaSelect = xmlId != null ? this.findMetaSelectById(xmlId) : this.findMetaSelectByName(name);
        HashMap<String, MetaSelectItem> itemMap = new HashMap<String, MetaSelectItem>();
        if (metaSelect == null) {
            metaSelect = new MetaSelect(name);
        } else {
            for (MetaSelectItem item : metaSelect.getItems()) {
                itemMap.put(item.getValue(), item);
            }
        }
        metaSelect.clearItems();
        int order = 1;
        for (String option : selection) {
            String value;
            String title;
            if ((option = option.trim()).contains(":") && option.indexOf(":") != option.length() - 1) {
                title = option.substring(option.indexOf(":") + 1);
                value = option.substring(0, option.indexOf(":"));
            } else {
                title = option;
                value = option;
            }
            MetaSelectItem metaSelectItem = this.updateItem(itemMap, order, title, value);
            ++order;
            metaSelect.addItem(metaSelectItem);
        }
        return metaSelect;
    }

    private MetaSelectItem updateItem(Map<String, MetaSelectItem> itemMap, int order, String title, String value) {
        MetaSelectItem metaSelectItem = itemMap.get(value);
        if (metaSelectItem == null) {
            metaSelectItem = new MetaSelectItem();
        }
        metaSelectItem.setTitle(title);
        metaSelectItem.setValue(value);
        metaSelectItem.setOrder(Integer.valueOf(order));
        return metaSelectItem;
    }

    private MetaSelect findMetaSelectByName(String name) {
        return (MetaSelect)((Object)this.metaSelectRepository.all().filter("self.name = ?1 and self.isCustom is true", new Object[]{name}).fetchOne());
    }

    private MetaSelect findMetaSelectById(String xmlId) {
        return (MetaSelect)((Object)this.metaSelectRepository.all().filter("self.xmlId = ?1 and self.isCustom is true", new Object[]{xmlId}).fetchOne());
    }

    private Integer getPriority(String name, String xmlId) {
        MetaSelect metaSelect = (MetaSelect)((Object)this.metaSelectRepository.all().filter("(self.xmlId is null OR self.xmlId != ?1) and self.name = ?2", new Object[]{xmlId, name}).fetchOne());
        if (metaSelect != null) {
            return metaSelect.getPriority() + 1;
        }
        return null;
    }
}

