/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.filter;

import com.axelor.meta.db.MetaField;
import java.util.Arrays;

public class FilterCommonService {
    public String getTagValue(String value, boolean addColon) {
        if (value != null) {
            if (addColon) {
                value = value.replace("$user", ":__user__");
                value = value.replace("$date", ":__date__");
                value = value.replace("$time", ":__datetime__");
            } else {
                value = value.replace("$user", "__user__");
                value = value.replace("$date", "__date__");
                value = value.replace("$time", "__datetime__");
            }
        }
        return value;
    }

    public String getLikeCondition(String conditionField, String value, boolean isLike) {
        String likeCondition = null;
        String likeOpr = "LIKE";
        if (!isLike) {
            likeOpr = "NOT LIKE";
        }
        if (value.contains(",")) {
            for (String val : Arrays.asList(value.split(","))) {
                if (likeCondition == null) {
                    likeCondition = conditionField + " " + likeOpr + " " + val;
                    continue;
                }
                likeCondition = likeCondition + " OR " + conditionField + " " + likeOpr + " " + val;
            }
        } else {
            likeCondition = conditionField + " " + likeOpr + " " + value;
        }
        return likeCondition;
    }

    public String getFieldType(MetaField metaField) {
        String relationship = metaField.getRelationship();
        if (relationship != null) {
            switch (relationship) {
                case "OneToMany": {
                    return "one-to-many";
                }
                case "ManyToMany": {
                    return "many-to-many";
                }
                case "ManyToOne": {
                    return "many-to-one";
                }
            }
        }
        return this.getFieldType(metaField.getTypeName());
    }

    public String getFieldType(String type) {
        switch (type) {
            case "String": {
                return "string";
            }
            case "Integer": {
                return "integer";
            }
            case "Boolean": {
                return "boolean";
            }
            case "BigDecimal": {
                return "decimal";
            }
            case "Long": {
                return "long";
            }
            case "byte[]": {
                return "binary";
            }
            case "LocalDate": {
                return "date";
            }
            case "ZonedDateTime": {
                return "datetime";
            }
            case "LocalDateTime": {
                return "datetime";
            }
        }
        return "string";
    }

    public String getCondition(String conditionField, String operator, String value) {
        value = this.getTagValue(value, true);
        String[] values = new String[]{""};
        if (value != null) {
            values = value.split(",");
        }
        switch (operator) {
            case "like": {
                return this.getLikeCondition(conditionField, value, true);
            }
            case "notLike": {
                return this.getLikeCondition(conditionField, value, false);
            }
            case "in": {
                return conditionField + " IN (" + value + ") ";
            }
            case "notIn": {
                return conditionField + " NOT IN (" + value + ") ";
            }
            case "isNull": {
                return conditionField + " IS NULL ";
            }
            case "notNull": {
                return conditionField + " IS NOT NULL ";
            }
            case "between": {
                if (values.length > 1) {
                    return conditionField + " BETWEEN  " + values[0] + " AND " + values[1];
                }
                return conditionField + " BETWEEN  " + values[0] + " AND " + values[0];
            }
            case "notBetween": {
                if (values.length > 1) {
                    return conditionField + " NOT BETWEEN  " + values[0] + " AND " + values[1];
                }
                return conditionField + " NOT BETWEEN  " + values[0] + " AND " + values[0];
            }
            case "isTrue": {
                return conditionField + " IS TRUE ";
            }
            case "isFalse": {
                return conditionField + " IS FALSE ";
            }
        }
        return conditionField + " " + operator + " " + value;
    }
}

