/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.filter;

import com.axelor.exception.AxelorException;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.studio.db.Filter;
import com.axelor.studio.service.filter.FilterCommonService;
import com.axelor.studio.service.filter.FilterSqlService;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterGroovyService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private FilterCommonService filterCommonService;
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    private MetaJsonFieldRepository metaJsonFieldRepo;
    @Inject
    private FilterSqlService filterSqlService;

    public String getGroovyFilters(List<Filter> conditions, String parentField, boolean isButton, boolean isField) throws AxelorException {
        String condition = null;
        if (conditions == null) {
            return null;
        }
        for (Filter filter : conditions) {
            String activeFilter = this.createGroovyFilter(filter, parentField, isButton, isField);
            this.log.debug("Active filter: {}", (Object)filter);
            if (condition == null) {
                condition = "(" + activeFilter;
                continue;
            }
            if (filter.getLogicOp() > 0) {
                condition = condition + ") || (" + activeFilter;
                continue;
            }
            condition = condition + " && " + activeFilter;
        }
        if (condition == null) {
            return null;
        }
        return condition + ")";
    }

    private String createGroovyFilter(Filter filter, String parentField, boolean isButton, boolean isField) throws AxelorException {
        String fieldType = null;
        boolean isJson = filter.getIsJson() == false && filter.getMetaField() != null ? false : filter.getIsJson() != false && filter.getMetaJsonField() != null;
        fieldType = !isJson ? this.getMetaFieldType(filter.getMetaField(), filter.getTargetField(), true) : this.getJsonFieldType(filter.getMetaJsonField(), filter.getTargetField());
        String targetField = filter.getTargetField();
        targetField = !isButton ? targetField.replace(".", "?.") : targetField;
        String value = this.processValue(filter);
        String operator = filter.getOperator();
        if (isButton || isField) {
            if (isJson && !Strings.isNullOrEmpty((String)parentField)) {
                boolean isModelFieldSame = ("$" + filter.getMetaJsonField().getModelField()).equals(parentField);
                if (!isModelFieldSame && isButton) {
                    targetField = "$record.$" + filter.getMetaJsonField().getModelField() + "." + targetField;
                } else if ((!isModelFieldSame || isModelFieldSame) && isField) {
                    targetField = "$" + filter.getMetaJsonField().getModelField() + "." + targetField;
                }
            } else if (!isJson && isButton) {
                targetField = "$record." + targetField;
            }
        }
        return this.getConditionExpr(operator, targetField, fieldType, value, isButton);
    }

    private String getJsonFieldType(MetaJsonField jsonField, String targetField) throws AxelorException {
        String targetName;
        if (targetField == null || !targetField.contains(".")) {
            return jsonField.getType();
        }
        String string = targetName = (targetField = targetField.substring(targetField.indexOf(".") + 1)).contains(".") ? targetField.substring(0, targetField.indexOf(".")) : targetField;
        if (jsonField.getTargetJsonModel() != null) {
            MetaJsonField subJson = (MetaJsonField)((Object)this.metaJsonFieldRepo.all().filter("self.name = ?1 and self.jsonModel = ?2", new Object[]{targetName, jsonField.getTargetJsonModel()}).fetchOne());
            if (subJson == null) {
                throw new AxelorException(1, "No sub field found model: %s field %s ", new Object[]{jsonField.getTargetJsonModel().getName(), targetName});
            }
            return this.getJsonFieldType(subJson, targetField);
        }
        MetaField subMeta = this.filterSqlService.findMetaField(targetName, jsonField.getTargetModel());
        if (subMeta == null) {
            throw new AxelorException(1, "No sub field found model: %s field %s ", new Object[]{jsonField.getTargetModel(), targetName});
        }
        return this.getMetaFieldType(subMeta, targetField, true);
    }

    private String getMetaFieldType(MetaField field, String targetField, boolean isJson) throws AxelorException {
        MetaJsonField subJson;
        if (targetField == null || !targetField.contains(".")) {
            return field.getTypeName();
        }
        String targetName = (targetField = targetField.substring(targetField.indexOf(".") + 1)).contains(".") ? targetField.substring(0, targetField.indexOf(".")) : targetField;
        MetaModel model = this.metaModelRepo.findByName(field.getTypeName());
        if (model == null) {
            throw new AxelorException(1, "No model found: %s ", new Object[]{field.getName()});
        }
        MetaField subMeta = this.filterSqlService.findMetaField(targetName, model.getFullName());
        if (subMeta != null) {
            return this.getMetaFieldType(subMeta, targetField, isJson);
        }
        if (isJson && (subJson = this.filterSqlService.findJsonField(targetName, model.getName())) != null) {
            return this.getJsonFieldType(subJson, targetField);
        }
        throw new AxelorException(1, "No sub field found field: %s model: %s ", new Object[]{targetName, model.getFullName()});
    }

    private String processValue(Filter filter) {
        String value = filter.getValue();
        if (value == null) {
            return value;
        }
        value = value.replace("$$", "__parent__.");
        return this.filterCommonService.getTagValue(value, false);
    }

    private String getConditionExpr(String operator, String field, String fieldType, String value, boolean isButton) {
        switch (operator) {
            case "isNull": {
                return field + " == null";
            }
            case "notNull": {
                return field + " != null";
            }
        }
        if (isButton) {
            switch (fieldType) {
                case "date": 
                case "datetime": 
                case "LocalDate": 
                case "LocalDateTime": {
                    value = "$moment(" + value + ")";
                    field = "$moment(" + field + ")";
                    switch (operator) {
                        case "=": {
                            return field + ".isSame(" + value + ", 'days')";
                        }
                        case "!=": {
                            return "!" + field + ".isSame(" + value + ", 'days')";
                        }
                    }
                }
            }
        }
        switch (operator) {
            case "=": {
                return field + " == " + value;
            }
            case "empty": {
                return field + ".empty";
            }
            case "notEmpty": {
                return "!" + field + ".empty";
            }
            case "isTrue": {
                return field;
            }
            case "isFalse": {
                return "!" + field;
            }
        }
        return field + " " + operator + " " + value;
    }
}

