/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.filter;

import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.studio.db.Filter;
import com.axelor.studio.service.filter.FilterCommonService;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterJpqlService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private FilterCommonService filterCommonService;

    public String getJpqlFilters(List<Filter> filterList) {
        String filters = null;
        if (filterList == null) {
            return filters;
        }
        for (Filter filter : filterList) {
            String fieldValue;
            String relationship;
            MetaField field = filter.getMetaField();
            if (filter.getValue() != null) {
                String value = filter.getValue();
                value = value.replaceAll("\"", "");
                value = value.replaceAll("'", "");
                if (filter.getOperator().contains("like") && !value.contains("%")) {
                    value = "%" + value + "%";
                }
                filter.setValue("'" + value + "'");
            }
            String fieldName = (relationship = field.getRelationship()) != null ? filter.getTargetField() : filter.getMetaField().getName();
            fieldName = "self." + fieldName;
            if (filter.getTargetType().equals("String")) {
                fieldName = "LOWER(" + fieldName + ")";
                fieldValue = "LOWER(" + filter.getValue() + ")";
            } else {
                fieldValue = filter.getValue();
            }
            String condition = this.filterCommonService.getCondition(fieldName, filter.getOperator(), fieldValue);
            if (filters == null) {
                filters = condition;
                continue;
            }
            String opt = filter.getLogicOp() != null && filter.getLogicOp() == 0 ? " AND " : " OR ";
            filters = filters + opt + condition;
        }
        this.log.debug("JPQL filter: {}", filters);
        return filters;
    }

    public String getJsonJpql(MetaJsonField jsonField) {
        switch (jsonField.getType()) {
            case "integer": {
                return "json_extract_integer";
            }
            case "decimal": {
                return "json_extract_decimal";
            }
            case "boolean": {
                return "json_extract_boolean";
            }
        }
        return "json_extract";
    }
}

