/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.wkf;

import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.common.Inflector;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaActionRepository;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.db.repo.MetaJsonModelRepository;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.ObjectViews;
import com.axelor.meta.schema.actions.ActionAttrs;
import com.axelor.meta.schema.actions.ActionGroup;
import com.axelor.meta.schema.actions.ActionMethod;
import com.axelor.meta.schema.actions.ActionRecord;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Extend;
import com.axelor.meta.schema.views.ExtendItemAttribute;
import com.axelor.meta.schema.views.ExtendItemReplace;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.PanelField;
import com.axelor.rpc.Request;
import com.axelor.rpc.Resource;
import com.axelor.studio.db.MenuBuilder;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfNode;
import com.axelor.studio.db.WkfTransition;
import com.axelor.studio.db.repo.MenuBuilderRepo;
import com.axelor.studio.db.repo.WkfRepository;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.builder.MenuBuilderService;
import com.axelor.studio.service.filter.FilterGroovyService;
import com.axelor.studio.service.wkf.WkfNodeService;
import com.axelor.studio.service.wkf.WkfTransitionService;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WkfService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Wkf workflow = null;
    protected String wkfCode = null;
    protected Inflector inflector;
    protected Integer wkfSequence = 0;
    protected Integer wkfSequencePreview = 0;
    protected String applyCondition = null;
    protected String trackingAction = null;
    protected String trackingActionPreview = null;
    protected String simpleModelName = null;
    protected String viewName = null;
    protected String actionName = null;
    @Inject
    protected RoleRepository roleRepo;
    @Inject
    private WkfNodeService nodeService;
    @Inject
    private WkfTransitionService transitionService;
    @Inject
    private StudioMetaService metaService;
    @Inject
    private MetaJsonFieldRepository jsonFieldRepo;
    @Inject
    private MetaJsonModelRepository jsonModelRepo;
    @Inject
    private MetaSelectRepository metaSelectRepo;
    @Inject
    private FilterGroovyService filterGroovyService;
    @Inject
    private WkfRepository wkfRepository;
    @Inject
    private MetaViewRepository metaViewRepo;
    @Inject
    private MetaActionRepository metaActionRepo;
    @Inject
    Resource<MetaView> resource;

    public String process(Wkf wkf) throws Exception {
        try {
            String defaultValue;
            this.initService(wkf);
            this.createTrackingAction();
            this.createPreviewTrackingAction();
            this.setWkfSequence();
            this.setWkfPreviewSequence();
            Map<String, Object> nodeValues = this.nodeService.process();
            String string = defaultValue = nodeValues.get("defaultValue") != null ? nodeValues.get("defaultValue").toString() : null;
            if (wkf.getIsJson().booleanValue() || wkf.getJsonField() != null) {
                if (this.workflow.getJsonField() != null) {
                    this.clearFields("", false);
                }
                this.clearMetaView();
                this.setJsonView();
                wkf.getStatusField().setDefaultValue(defaultValue);
                wkf.setGeneratedMetaView(null);
            } else {
                if (this.workflow.getJsonField() == null) {
                    this.clearFields("", false);
                }
                this.clearMetaView();
                this.setMetaView(defaultValue);
            }
            this.createTrackFlowButton();
            this.setPreview();
            List actions = (List)nodeValues.get("nodeActions");
            actions.addAll(this.transitionService.process());
            actions.add(new String[]{"save"});
            actions.add(new String[]{this.trackingAction});
            this.updateActionGroup("action-group-" + this.wkfCode, actions);
            ArrayList<String[]> previewActions = new ArrayList<String[]>();
            previewActions.add(new String[]{"save"});
            previewActions.add(new String[]{this.trackingActionPreview});
            this.updateActionGroup("action-group-" + this.workflow.getCode(), previewActions);
            this.setStatusValue();
            MetaStore.clear();
        }
        catch (Exception e) {
            if (Objects.equal((Object)e.getMessage(), (Object)"Can't alter nodes for real existing selection field")) {
                throw e;
            }
            e.printStackTrace();
            return e.toString();
        }
        return null;
    }

    private void initService(Wkf wkf) {
        this.workflow = wkf;
        this.inflector = Inflector.getInstance();
        this.wkfCode = "wkf" + wkf.getCode() + "wkf";
        this.trackingAction = "action-method-wkf-track-" + this.wkfCode;
        this.trackingActionPreview = "action-method-wkf-track-" + this.workflow.getCode();
        if (!wkf.getIsJson().booleanValue() && wkf.getJsonField() == null) {
            this.simpleModelName = StringUtils.substringAfterLast((String)this.workflow.getModel(), (String)".");
            this.viewName = this.inflector.dasherize(this.simpleModelName) + "-form";
            this.actionName = "action-studio-" + this.inflector.dasherize(this.simpleModelName) + "-record-set-onnew";
        }
    }

    private void setJsonView() throws AxelorException {
        String jsonField;
        MetaJsonField status = this.workflow.getStatusField();
        String string = jsonField = this.workflow.getIsJson() != false ? null : "$" + this.workflow.getJsonField();
        if (jsonField != null && jsonField.equals("$null")) {
            jsonField = null;
        }
        this.applyCondition = this.filterGroovyService.getGroovyFilters(this.workflow.getConditions(), jsonField, true, false);
        if (!Strings.isNullOrEmpty((String)this.applyCondition)) {
            this.applyCondition = this.applyCondition.replace("?.", ".");
        }
        MetaJsonField panel = this.getJsonField(this.wkfCode + "Panel", "panel");
        panel.setSequence(this.wkfSequence - 49);
        panel.setVisibleInGrid(false);
        panel.setIsWkf(true);
        panel.setWidgetAttrs("{\"colSpan\": \"12\"}");
        panel.setShowIf(null);
        this.saveJsonField(panel);
        status.setSequence(this.wkfSequence - 48);
        status.setSelection(this.getSelectName());
        status.setWidget(null);
        status.setIsWkf(true);
        status.setReadonly(true);
        status.setShowIf(this.applyCondition);
        status.setWidgetAttrs("{\"colSpan\": \"10\"}");
        if (this.workflow.getDisplayTypeSelect() == 0) {
            status.setWidget("NavSelect");
        }
        this.saveJsonField(this.workflow.getStatusField());
        MetaJsonField wkfEnd = this.getJsonField(this.wkfCode + "Separator", "separator");
        wkfEnd.setSequence(this.wkfSequence);
        wkfEnd.setVisibleInGrid(false);
        wkfEnd.setIsWkf(true);
        wkfEnd.setWidgetAttrs("{\"colSpan\": \"12\"}");
        this.saveJsonField(wkfEnd);
    }

    private void setPreview() {
        String model = "com.axelor.studio.db.Wkf";
        if (this.findJsonField(this.wkfCode + this.workflow.getCode() + "Panel", model) == null) {
            MetaJsonField panel = this.getJsonField(this.wkfCode + "Panel", "panel");
            panel = (MetaJsonField)((Object)this.jsonFieldRepo.copy((Model)((Object)panel), true));
            panel.setName(this.wkfCode + this.workflow.getCode() + "Panel");
            this.createPreviewMetaJsonField(panel, 49, "$record.code == '" + this.workflow.getCode() + "' && $record.id != null");
        }
        String statusFieldName = this.getWkfFieldInfo(this.workflow)[0];
        if (this.findJsonField(this.wkfCode + statusFieldName, model) == null) {
            MetaJsonField status = null;
            if (this.workflow.getIsJson().booleanValue() || this.workflow.getJsonField() != null) {
                status = (MetaJsonField)((Object)this.jsonFieldRepo.copy((Model)((Object)this.workflow.getStatusField()), true));
            } else {
                status = new MetaJsonField();
                status.setType(this.workflow.getStatusMetaField().getTypeName().toLowerCase());
                status.setTitle(this.workflow.getStatusMetaField().getLabel());
                status.setDefaultValue("1");
                status.setSelection(this.getSelectName());
                status.setWidgetAttrs("{\"colSpan\": \"12\"}");
                if (this.workflow.getDisplayTypeSelect() == 0) {
                    status.setWidget("NavSelect");
                }
                status.setReadonly(true);
            }
            status.setName(this.wkfCode + statusFieldName);
            this.createPreviewMetaJsonField(status, 48, "$record.code == '" + this.workflow.getCode() + "' && $record.id != null");
        }
        if (this.findJsonField(this.wkfCode + this.workflow.getCode() + "TrackFlow", model) == null) {
            MetaJsonField trackFlow = this.getJsonField(this.wkfCode + "TrackFlow", "button");
            trackFlow = (MetaJsonField)((Object)this.jsonFieldRepo.copy((Model)((Object)trackFlow), true));
            trackFlow.setName(this.wkfCode + this.workflow.getCode() + "TrackFlow");
            this.createPreviewMetaJsonField(trackFlow, 47, "$record.code == '" + this.workflow.getCode() + "' && $record.isTrackFlow == true && $record.id != null");
        }
        if (this.findJsonField(this.wkfCode + this.workflow.getCode() + "Spacer", model) == null) {
            MetaJsonField wkfEnd = new MetaJsonField();
            wkfEnd.setName(this.wkfCode + this.workflow.getCode() + "Spacer");
            wkfEnd.setType("spacer");
            this.createPreviewMetaJsonField(wkfEnd, 0, "$record.code == '" + this.workflow.getCode() + "' && $record.id != null");
        }
    }

    public void createPreviewMetaJsonField(MetaJsonField jsonField, int sequence, String condition) {
        jsonField.setSequence(this.wkfSequencePreview - sequence);
        jsonField.setModel("com.axelor.studio.db.Wkf");
        jsonField.setModelField("attrs");
        jsonField.setJsonModel(null);
        jsonField.setShowIf(condition);
        this.saveJsonField(jsonField);
    }

    private void setMetaView(String defaultValue) {
        try {
            MetaView existingMetaView = this.workflow.getMetaView();
            ObjectViews formViews = XMLViews.fromXML((String)existingMetaView.getXml());
            FormView existingFormView = (FormView)formViews.getViews().get(0);
            String oldOnNew = existingFormView.getOnNew();
            String newOnNew = this.createAction(oldOnNew, defaultValue);
            FormView formView = existingFormView;
            formView.setExtends(this.addExtendItems(newOnNew));
            formView.setXmlId("studio-" + this.viewName);
            formView.setExtension(Boolean.valueOf(true));
            formView.setItems(null);
            formView.setMenubar(null);
            formView.setToolbar(null);
            MetaView newView = (MetaView)this.metaViewRepo.all().filter("self.name = ?1 AND self.model = ?2 AND self.type = ?3 AND self.xmlId = ?4", new Object[]{this.viewName, this.workflow.getModel(), "form", "studio-" + this.viewName}).fetchOne();
            if (newView == null) {
                newView = new MetaView();
                newView.setName(this.viewName);
                newView.setType(formView.getType());
                newView.setTitle(formView.getTitle());
                newView.setModel(formView.getModel());
                newView.setModule("axelor-studio");
            }
            newView.setXmlId(formView.getXmlId());
            newView.setExtension(Boolean.valueOf(true));
            newView.setXml(XMLViews.toXml((Object)formView, (boolean)true));
            this.saveMetaView(newView);
        }
        catch (JAXBException e) {
            String message = I18n.get((String)"Invalid XML.");
            Throwable ex = e.getLinkedException();
            if (ex != null) {
                message = ex.getMessage().replaceFirst("[^:]+\\:(.*)", "$1");
            }
            throw new IllegalArgumentException(message);
        }
    }

    @Transactional
    public String createAction(String oldOnNew, String defaultValue) {
        String newOnNew = null;
        newOnNew = Strings.isNullOrEmpty((String)oldOnNew) ? this.actionName : oldOnNew + "," + this.actionName;
        ActionRecord newActionRecord = new ActionRecord();
        newActionRecord.setName(this.actionName);
        newActionRecord.setModel(this.workflow.getModel());
        newActionRecord.setFields(new ArrayList());
        ActionRecord.RecordField recordField = new ActionRecord.RecordField();
        recordField.setName(this.workflow.getStatusMetaField().getName());
        recordField.setExpression("eval: " + defaultValue);
        newActionRecord.getFields().add(recordField);
        MetaAction action = (MetaAction)((Object)this.metaActionRepo.all().filter("self.name = ?1 AND self.model = ?2 AND self.type = ?3 AND self.module = ?4", new Object[]{this.actionName, this.simpleModelName, "action-record", "axelor-studio"}).fetchOne());
        if (action == null) {
            action = new MetaAction();
            action.setName(this.actionName);
            action.setType("action-record");
            action.setModel(this.simpleModelName);
            action.setModule("axelor-studio");
        }
        action.setXml(XMLViews.toXml((Object)newActionRecord, (boolean)true));
        this.metaActionRepo.save((Model)((Object)action));
        return newOnNew;
    }

    private List<Extend> addExtendItems(String onNew) {
        ArrayList<Extend> extendItems = new ArrayList<Extend>();
        try {
            MetaField statusField = this.workflow.getStatusMetaField();
            Extend extend1 = new Extend();
            extend1.setTarget("/");
            extend1.setAttributes(new ArrayList());
            ExtendItemAttribute attribute = new ExtendItemAttribute();
            attribute.setName("onNew");
            attribute.setValue(onNew);
            extend1.getAttributes().add(attribute);
            extendItems.add(extend1);
            Extend extend2 = new Extend();
            String target = "//field[@name='" + statusField.getName() + "']";
            extend2.setTarget(target);
            extend2.setReplaces(new ArrayList());
            ExtendItemReplace replace = new ExtendItemReplace();
            replace.setItems(new ArrayList());
            replace.getItems().add(this.createField());
            extend2.getReplaces().add(replace);
            extendItems.add(extend2);
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
        return extendItems;
    }

    private AbstractWidget createField() throws AxelorException {
        this.applyCondition = this.filterGroovyService.getGroovyFilters(this.workflow.getConditions(), "$attrs", false, true);
        if (!Strings.isNullOrEmpty((String)this.applyCondition)) {
            this.applyCondition = this.applyCondition.replace("?.", ".");
        }
        PanelField field = new PanelField();
        field.setName(this.workflow.getStatusMetaField().getName());
        field.setSelection(this.getSelectName());
        field.setReadonly(Boolean.valueOf(true));
        field.setColSpan(Integer.valueOf(12));
        field.setWidget(null);
        if (this.workflow.getDisplayTypeSelect() == 0) {
            field.setWidget("NavSelect");
        }
        field.setShowIf(this.applyCondition);
        return field;
    }

    @Transactional
    public void clearOldStatusField() {
        MetaJsonField field = null;
        String modelField = this.workflow.getJsonField() != null ? this.workflow.getJsonField() : "attrs";
        field = this.workflow.getIsJson() != false ? (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.jsonModel.name = :workflowModel and self.type in ('string','integer')").bind("workflowModel", (Object)this.workflow.getModel()).fetchOne()) : (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.model = :workflowModel and self.modelField = :workflowJsonField and self.type in ('string','integer')").bind("workflowModel", (Object)this.workflow.getModel()).bind("workflowJsonField", (Object)modelField).fetchOne());
        if (field != null) {
            if (field.getSelection() != null) {
                this.log.debug("Cleaning old status field: {}", (Object)field);
                MetaSelect oldSelect = this.metaSelectRepo.findByName(field.getSelection());
                if (oldSelect != null) {
                    this.log.debug("Removing old wkf selection: {}", (Object)oldSelect);
                    this.metaSelectRepo.remove((Model)((Object)oldSelect));
                }
            }
            field.setIsWkf(false);
            field.setSelection(null);
            field.setSequence(0);
            field.setReadonly(false);
            this.jsonFieldRepo.save((Model)((Object)field));
        }
    }

    public String getSelectName() {
        if (this.workflow != null) {
            String wkfFieldName = this.getWkfFieldInfo(this.workflow)[0];
            String selectName = "wkf." + this.inflector.dasherize(this.workflow.getName()).replace("_", ".");
            selectName = selectName + "." + this.inflector.dasherize(wkfFieldName).replace("_", ".") + ".select";
            return selectName;
        }
        return null;
    }

    protected ActionGroup updateActionGroup(String name, List<String[]> actions) {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.setName(name);
        ArrayList<ActionGroup.ActionItem> actionItems = new ArrayList<ActionGroup.ActionItem>();
        for (String[] action : actions) {
            ActionGroup.ActionItem actionItem = new ActionGroup.ActionItem();
            actionItem.setName(action[0]);
            if (action.length > 1) {
                actionItem.setCondition(action[1]);
            }
            actionItems.add(actionItem);
        }
        actionGroup.setActions(actionItems);
        String xml = XMLViews.toXml((Object)actionGroup, (boolean)true);
        this.metaService.updateMetaAction(name, "action-group", xml, null);
        return actionGroup;
    }

    public MetaJsonField getJsonField(String name, String type) {
        String modelField;
        MetaJsonField field = null;
        String string = modelField = this.workflow.getJsonField() != null ? this.workflow.getJsonField() : "attrs";
        if (this.workflow.getIsJson().booleanValue()) {
            field = (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.jsonModel.name = ?1 and self.name = ?2 and self.type = ?3", new Object[]{this.workflow.getModel(), name, type}).fetchOne());
            if (field == null) {
                field = new MetaJsonField();
                field.setModel(MetaJsonRecord.class.getName());
                field.setModelField("attrs");
                field.setJsonModel(this.jsonModelRepo.findByName(this.workflow.getModel()));
            }
        } else {
            field = (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.isWkf = true and self.model = :workflowModel and self.modelField = :workflowJsonField and self.name = :name and self.type = :type").bind("workflowModel", (Object)this.workflow.getModel()).bind("workflowJsonField", (Object)modelField).bind("name", (Object)name).bind("type", (Object)type).fetchOne());
            this.log.debug("Searching json field with model: {}, field: {}, name: {}, type: {}", new Object[]{this.workflow.getModel(), modelField, name, type});
            if (field == null) {
                field = new MetaJsonField();
                field.setModel(this.workflow.getModel());
                field.setModelField(modelField);
                field.setName(name);
            }
        }
        field.setType(type);
        field.setName(name);
        field.setIsWkf(true);
        field.setShowIf(this.applyCondition);
        return this.saveJsonField(field);
    }

    @Transactional
    public MetaJsonField saveJsonField(MetaJsonField jsonField) {
        this.workflow.setWkfModel(this.workflow.getModel());
        return (MetaJsonField)((Object)this.jsonFieldRepo.save((Model)((Object)jsonField)));
    }

    public MetaJsonField findJsonField(String name, String model) {
        return (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.name = ?1 AND self.model = ?2", new Object[]{name, model}).fetchOne());
    }

    @Transactional
    public MetaView saveMetaView(MetaView metaView) {
        metaView = (MetaView)this.metaViewRepo.save((Model)metaView);
        Request request = new Request();
        request.setData(Mapper.toMap((Object)metaView));
        this.resource.save(request);
        this.workflow.setGeneratedMetaView(metaView);
        return metaView;
    }

    @Transactional
    public void clearWkf(Wkf wkf) {
        this.initService(wkf);
        String actions = "action-" + this.wkfCode + ",action-group-" + this.wkfCode + ",action-group-" + this.workflow.getCode();
        actions = this.clearFields(actions, true);
        StringBuilder builder = new StringBuilder(actions);
        for (WkfNode node : wkf.getNodes()) {
            if (!node.getMetaActionSet().isEmpty()) {
                builder.append("," + this.nodeService.getActionName(node.getName()));
            }
            if (node.getMenuBuilder() == null || node.getMenuBuilder().getMetaMenu() == null) continue;
            ((MenuBuilderRepo)((Object)Beans.get(MenuBuilderRepo.class))).remove(node.getMenuBuilder());
            node.setMenuBuilder(null);
        }
        builder.append("," + this.trackingAction + "," + this.trackingActionPreview);
        actions = builder.toString();
        this.metaService.removeMetaActions(actions);
        String select = this.getSelectName();
        MetaSelect metaSelect = this.metaSelectRepo.findByName(select);
        if (metaSelect != null) {
            this.metaSelectRepo.remove((Model)((Object)metaSelect));
        }
        if (this.workflow.getIsJson().booleanValue()) {
            MetaJsonField status = wkf.getStatusField();
            status.setWidget(null);
            status.setSelection(null);
            status.setWidgetAttrs(null);
            this.saveJsonField(status);
        } else if (this.workflow.getJsonField() != null) {
            this.jsonFieldRepo.remove((Model)((Object)this.workflow.getStatusField()));
        } else {
            this.clearMetaView();
        }
    }

    public List<MetaJsonField> clearMetaJsonField() {
        List metaJsonFieldList = this.jsonFieldRepo.all().filter("self.name LIKE :code and self.model =?1 and self.modelField =?2", new Object[]{"com.axelor.studio.db.Wkf", "attrs"}).bind("code", (Object)(this.wkfCode + "%")).fetch();
        return metaJsonFieldList;
    }

    @Transactional
    public void clearMetaView() {
        MetaView generatedView = this.workflow.getGeneratedMetaView();
        if (generatedView == null) {
            return;
        }
        this.metaViewRepo.all().filter("self.name = ?1 AND self.model = ?2 AND self.type = ?3 AND self.priority = ?4 AND self.computed = 'true'", new Object[]{generatedView.getName(), generatedView.getModel(), "form", generatedView.getPriority() + 1}).remove();
        String model = StringUtils.substringAfterLast((String)generatedView.getModel(), (String)".");
        String actionName = "action-studio-" + this.inflector.dasherize(model) + "-record-set-onnew";
        this.metaActionRepo.all().filter("self.name = ?1 AND self.model = ?2 AND self.type = ?3 AND self.module = ?4", new Object[]{actionName, model, "action-record", "axelor-studio"}).remove();
        this.workflow.setGeneratedMetaView(null);
        this.metaViewRepo.remove((Model)generatedView);
    }

    private String clearFields(String actions, boolean fromRemove) {
        List<MetaJsonField> fields = this.getFields(fromRemove);
        List<MetaJsonField> jsonFields = this.clearMetaJsonField();
        List combinedList = ListUtils.union(fields, jsonFields);
        StringBuilder builder = new StringBuilder(actions);
        for (MetaJsonField field : combinedList) {
            if (field.getIsWkf().booleanValue() && !field.equals((Object)this.workflow.getStatusField())) {
                if (field.getOnClick() != null) {
                    builder.append("," + field.getOnClick());
                }
                this.jsonFieldRepo.remove((Model)((Object)field));
                continue;
            }
            this.jsonFieldRepo.remove((Model)((Object)field));
        }
        return builder.toString();
    }

    private List<MetaJsonField> getFields(boolean fromRemove) {
        String modelField = this.workflow.getJsonField() != null ? this.workflow.getJsonField() : "attrs";
        String query = "self.isWkf = true and ";
        List fields = this.workflow.getIsJson() != false ? this.jsonFieldRepo.all().filter(query + "self.name LIKE '" + this.wkfCode + "%' and self.jsonModel.name = ?1", new Object[]{this.workflow.getModel()}).fetch() : this.jsonFieldRepo.all().filter(query + "self.name LIKE 'wkf%' and self.model = ?1 and self.modelField = ?2", new Object[]{fromRemove ? this.workflow.getModel() : (this.workflow.getGeneratedMetaView() != null ? this.workflow.getGeneratedMetaView().getModel() : this.workflow.getWkfModel()), modelField}).fetch();
        return fields;
    }

    @Transactional
    public String clearOldButtons(List<String> skipList) {
        this.log.debug("Cleaning old buttons. Skip list: {}", skipList);
        if (CollectionUtils.isEmpty(skipList)) {
            return null;
        }
        skipList.add(this.wkfCode + "TrackFlow");
        ArrayList<String> actions = new ArrayList<String>();
        List fields = new ArrayList();
        List finalList = new ArrayList();
        String modelField = this.workflow.getJsonField() != null ? this.workflow.getJsonField() : "attrs";
        fields = this.workflow.getIsJson() != false ? this.jsonFieldRepo.all().filter("self.type = 'button' and self.jsonModel.name = ?1 and self.isWkf = true and self.name NOT IN (?2) and self.name LIKE ?3 ", new Object[]{this.workflow.getModel(), skipList, this.wkfCode + "%"}).fetch() : this.jsonFieldRepo.all().filter("self.type = 'button' and self.model = ?1 and self.modelField = ?2 and self.name NOT IN (?3) and self.name LIKE ?4", new Object[]{this.workflow.getModel(), modelField, skipList, this.wkfCode + "%"}).fetch();
        List metaJsonFields = this.jsonFieldRepo.all().filter("self.type = 'button' and self.name LIKE :code and self.model = ?1 and self.modelField = ?2 and self.name NOT IN (?3)", new Object[]{"com.axelor.studio.db.Wkf", "attrs", skipList}).bind("code", (Object)(this.wkfCode + "Transition%Button")).fetch();
        finalList = ListUtils.union(fields, (List)metaJsonFields);
        this.log.debug("Total Buttons to remove: {}", (Object)finalList.size());
        Iterator buttons = finalList.iterator();
        while (buttons.hasNext()) {
            MetaJsonField button = (MetaJsonField)((Object)buttons.next());
            String onClick = button.getOnClick();
            this.log.debug("Removing button : {}, onClick: {}", (Object)button.getName(), (Object)onClick);
            if (onClick != null) {
                for (String action : onClick.split(",")) {
                    if (action.equals("action-group-" + this.wkfCode) || action.equals("action-group-" + this.workflow.getCode())) continue;
                    actions.add(action);
                }
            }
            buttons.remove();
            this.jsonFieldRepo.remove((Model)((Object)button));
        }
        return Joiner.on((String)",").join(actions);
    }

    @Transactional
    public void setWkfPreviewSequence() {
        int buttonCount = 0;
        int newButton = 0;
        for (WkfTransition transition : this.workflow.getTransitions()) {
            if (transition.getIsButton().booleanValue()) {
                ++buttonCount;
            }
            if (!transition.getIsButton().booleanValue() || transition.getConditions() != null) continue;
            ++newButton;
        }
        if (newButton != buttonCount && newButton > 0) {
            MetaJsonField jsonField = (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.type = :type AND self.model = :model AND self.jsonModel is null AND self.name LIKE :code").bind("type", (Object)"spacer").bind("model", (Object)"com.axelor.studio.db.Wkf").bind("code", (Object)("%" + this.workflow.getCode() + "%")).order("sequence").fetchOne());
            this.wkfSequencePreview = jsonField.getSequence();
            return;
        }
        MetaJsonField metaJsonField = (MetaJsonField)((Object)this.jsonFieldRepo.all().filter("self.type = :type AND self.model = :model AND self.jsonModel is null").bind("type", (Object)"spacer").bind("model", (Object)"com.axelor.studio.db.Wkf").order("sequence").fetchOne());
        if (metaJsonField == null) {
            this.wkfSequencePreview = -1;
        } else if (buttonCount > 0) {
            this.wkfSequencePreview = metaJsonField.getSequence() - 15;
        }
    }

    public void setStatusValue() {
        ActionAttrs actionAttrs = new ActionAttrs();
        actionAttrs.setName("action-wkf-attrs-set-status-field-value");
        ActionAttrs.Attribute attribute = new ActionAttrs.Attribute();
        attribute.setExpression("eval:'1'");
        attribute.setFieldName("wkf" + this.workflow.getCode() + "wkf" + this.getWkfFieldInfo(this.workflow)[0]);
        attribute.setName("value");
        ArrayList<ActionAttrs.Attribute> attributes = new ArrayList<ActionAttrs.Attribute>();
        attributes.add(attribute);
        actionAttrs.setAttributes(attributes);
        String xml = XMLViews.toXml((Object)actionAttrs, (boolean)true);
        this.metaService.updateMetaAction("action-wkf-attrs-set-status-field-value", "action-attrs", xml, null);
    }

    public void clearNodes(Collection<WkfNode> nodes) {
        ArrayList<String> actions = new ArrayList<String>();
        for (WkfNode node : nodes) {
            if (this.workflow == null) {
                this.workflow = node.getWkf();
            }
            if (!node.getMetaActionSet().isEmpty()) {
                actions.add(this.nodeService.getActionName(node.getName()));
            }
            if (node.getMenuBuilder() == null || node.getMenuBuilder().getMetaMenu() == null) continue;
            ((MenuBuilderRepo)((Object)Beans.get(MenuBuilderRepo.class))).remove(node.getMenuBuilder());
        }
        this.metaService.removeMetaActions(Joiner.on((String)",").join(actions));
    }

    public void createTrackFlowButton() {
        MetaJsonField trackFlow = this.getJsonField(this.wkfCode + "TrackFlow", "button");
        trackFlow.setSequence(this.wkfSequence - 47);
        trackFlow.setTitle("Track flow");
        trackFlow.setWidgetAttrs("{\"colSpan\": \"2\"}");
        trackFlow.setOnClick("action-wkf-open-wkf-tracking");
        trackFlow.setIsWkf(true);
        trackFlow.setVisibleInGrid(false);
        trackFlow.setHidden(this.workflow.getIsTrackFlow() == false);
        this.saveJsonField(trackFlow);
    }

    @Transactional
    public void createTrackingAction() {
        ActionMethod actionMethod = new ActionMethod();
        actionMethod.setName(this.trackingAction);
        ActionMethod.Call call = new ActionMethod.Call();
        call.setMethod("track(" + this.workflow.getId() + ",__self__,false)");
        call.setController("com.axelor.studio.service.wkf.WkfTrackingService");
        actionMethod.setCall(call);
        String xml = XMLViews.toXml((Object)actionMethod, (boolean)true);
        this.metaService.updateMetaAction(this.trackingAction, "action-method", xml, null);
    }

    @Transactional
    public void createPreviewTrackingAction() {
        ActionMethod actionMethod = new ActionMethod();
        actionMethod.setName(this.trackingActionPreview);
        ActionMethod.Call call = new ActionMethod.Call();
        call.setMethod("track(" + this.workflow.getId() + ",__self__,true)");
        call.setController("com.axelor.studio.service.wkf.WkfTrackingService");
        actionMethod.setCall(call);
        String xml = XMLViews.toXml((Object)actionMethod, (boolean)true);
        this.metaService.updateMetaAction(this.trackingActionPreview, "action-method", xml, null);
    }

    @Transactional
    public void setWkfSequence() {
        Wkf wkf = (Wkf)((Object)this.wkfRepository.all().filter("self.model = ?1", new Object[]{this.workflow.getModel()}).order("wkfSequence").fetchOne());
        if (wkf.getId() != this.workflow.getId() && this.workflow.getWkfSequence() == 0) {
            this.workflow.setWkfSequence(wkf.getWkfSequence() - 50);
            this.wkfRepository.save((Model)((Object)this.workflow));
        } else if (this.workflow.getWkfSequence() == 0) {
            this.workflow.setWkfSequence(-1);
            this.wkfRepository.save((Model)((Object)this.workflow));
        }
        this.wkfSequence = this.workflow.getWkfSequence();
    }

    public String[] getWkfFieldInfo(Wkf wkf) {
        String wkfFieldName = null;
        String wkfFieldType = null;
        if (wkf.getIsJson().booleanValue() || wkf.getJsonField() != null) {
            MetaJsonField statusField = wkf.getStatusField();
            wkfFieldName = statusField.getName();
            wkfFieldType = statusField.getType();
        } else {
            MetaField statusMetaField = wkf.getStatusMetaField();
            wkfFieldName = statusMetaField.getName();
            wkfFieldType = statusMetaField.getTypeName();
        }
        return new String[]{wkfFieldName, wkfFieldType};
    }

    public void manageMenuBuilder(WkfNode node) {
        if (node.getIsGenerateMenu().booleanValue()) {
            Wkf wkf = node.getWkf();
            MenuBuilder menuBuilder = node.getMenuBuilder();
            if (menuBuilder != null) {
                String menuName = String.format("%s-%s-%s", wkf.getModel(), node.getName(), (int)(Math.random() * 100.0));
                Boolean isJson = wkf.getIsJson();
                String domain = this.getDomain(wkf, node.getSequence());
                MenuBuilder menuBuilder2 = ((MenuBuilderService)Beans.get(MenuBuilderService.class)).updateMenuBuilder(menuBuilder, wkf.getModel(), menuName, wkf.getAppBuilder(), isJson != false ? MetaJsonRecord.class.getName() : wkf.getModel(), wkf.getIsJson(), domain);
            }
        }
    }

    private String getDomain(Wkf wkf, Integer fieldValue) {
        if (wkf.getIsJson().booleanValue()) {
            return String.format("json_extract_integer(self.attrs, '%s') = %s", wkf.getStatusField().getName(), fieldValue);
        }
        return String.format("self.%s = %s", wkf.getStatusMetaField().getName(), fieldValue);
    }
}

