/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.wkf;

import com.axelor.common.Inflector;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaJsonRecord;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.schema.views.Selection;
import com.axelor.rpc.Context;
import com.axelor.rpc.JsonContext;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.WkfTracking;
import com.axelor.studio.db.WkfTrackingLine;
import com.axelor.studio.db.WkfTrackingTime;
import com.axelor.studio.db.WkfTrackingTotal;
import com.axelor.studio.db.repo.WkfRepository;
import com.axelor.studio.db.repo.WkfTrackingLineRepository;
import com.axelor.studio.db.repo.WkfTrackingRepository;
import com.axelor.studio.db.repo.WkfTrackingTimeRepository;
import com.axelor.studio.db.repo.WkfTrackingTotalRepository;
import com.axelor.studio.service.wkf.WkfService;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WkfTrackingService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTION_TRACK = "action-method-wkf-track";
    public static final String ACTION_OPEN_TRACK = "action-wkf-open-wkf-tracking";
    @Inject
    private WkfRepository wkfRepo;
    @Inject
    private WkfTrackingRepository wkfTrackingRepo;
    @Inject
    private WkfTrackingLineRepository trackingLineRepo;
    @Inject
    private WkfTrackingTotalRepository trackingTotalRepo;
    @Inject
    private WkfTrackingTimeRepository trackingTimeRepo;
    @Inject
    private MetaJsonFieldRepository jsonFieldRepo;
    private BigDecimal durationHrs;
    private String oldStatus;

    @CallMethod
    public void track(Long wkfId, Object object, boolean isPreview) {
        if (object != null) {
            String wkfFieldName;
            Context ctx = null;
            object = EntityHelper.getEntity((Object)object);
            Model model = (Model)object;
            if (object instanceof MetaJsonRecord) {
                this.log.debug("Meta json record context");
                MetaJsonRecord metaJsonRecord = (MetaJsonRecord)object;
                this.log.debug("Json id: {}, Json model: {}", (Object)metaJsonRecord.getId(), (Object)metaJsonRecord.getJsonModel());
                ctx = new JsonContext((MetaJsonRecord)object);
                ctx.put("id", (Object)metaJsonRecord.getId());
                ctx.put("jsonModel", (Object)metaJsonRecord.getJsonModel());
            } else {
                ctx = new Context(model.getId(), object.getClass());
            }
            ctx.put("wkfId", (Object)wkfId);
            WkfTracking wkfTracking = this.getWorkflowTracking((SimpleBindings)ctx, object.getClass().getName());
            if (wkfTracking == null) {
                return;
            }
            String selectionFieldName = wkfFieldName = ((WkfService)Beans.get(WkfService.class)).getWkfFieldInfo(wkfTracking.getWkf())[0];
            if (isPreview) {
                wkfFieldName = this.jsonFieldRepo.findByName("wkf" + wkfTracking.getWkf().getCode() + "wkf" + wkfFieldName).getName();
            }
            String selection = "wkf." + Inflector.getInstance().dasherize(wkfTracking.getWkf().getName()).replace("_", ".");
            selection = selection + "." + Inflector.getInstance().dasherize(selectionFieldName).replace("_", ".") + ".select";
            Object status = null;
            status = ctx.get(wkfFieldName);
            this.log.debug("Status value: {}", status);
            if (status == null) {
                return;
            }
            Selection.Option item = MetaStore.getSelectionItem((String)selection, (String)status.toString());
            this.log.debug("Fetching option {} from selection {}", status, (Object)selection);
            if (item == null) {
                return;
            }
            this.durationHrs = BigDecimal.ZERO;
            WkfTrackingLine trackingLine = this.updateTrackingLine(wkfTracking, item.getTitle());
            if (trackingLine != null) {
                this.updateTrackingTotal(wkfTracking, item.getTitle());
                this.updateTrackingTime(wkfTracking, item.getTitle());
            }
        }
    }

    @Transactional
    public WkfTracking getWorkflowTracking(SimpleBindings ctx, String model) {
        Wkf wkf;
        String jsonModel = (String)ctx.get("jsonModel");
        this.log.debug("Context json model: {}", (Object)jsonModel);
        if (jsonModel != null) {
            model = jsonModel;
        }
        if ((wkf = (Wkf)((Object)this.wkfRepo.find((Long)ctx.get("wkfId")))) == null) {
            return null;
        }
        WkfTracking wkfTracking = (WkfTracking)((Object)this.wkfTrackingRepo.all().filter("self.wkf = ?1 and self.recordModel = ?2 and self.recordId = ?3", new Object[]{wkf, model, ctx.get("id")}).fetchOne());
        if (wkfTracking == null) {
            wkfTracking = new WkfTracking();
            wkfTracking.setWkf(wkf);
            wkfTracking.setRecordModel(model);
            wkfTracking.setRecordId((Long)ctx.get("id"));
            wkfTracking = (WkfTracking)((Object)this.wkfTrackingRepo.save((Model)((Object)wkfTracking)));
        }
        return wkfTracking;
    }

    @Transactional
    public WkfTrackingLine updateTrackingLine(WkfTracking wkfTracking, String status) {
        WkfTrackingLine trackingLine = (WkfTrackingLine)((Object)this.trackingLineRepo.all().filter("self.wkfTracking = ?1", new Object[]{wkfTracking}).fetchOne());
        if (trackingLine == null || !trackingLine.getStatus().equals(status)) {
            LocalDateTime now = LocalDateTime.now();
            if (trackingLine != null) {
                this.oldStatus = trackingLine.getStatus();
                LocalDateTime lastUpdated = trackingLine.getCreatedOn();
                long minutes = Duration.between(lastUpdated, now).toMinutes();
                this.log.debug("Minutes between {} and {} : {}", new Object[]{lastUpdated, now, minutes});
                this.durationHrs = new BigDecimal(minutes).divide(new BigDecimal(60), 2, RoundingMode.HALF_UP);
                this.log.debug("Hours between {} and {} : {}", new Object[]{lastUpdated, now, this.durationHrs});
                trackingLine.setTimeSpent(this.durationHrs);
                this.trackingLineRepo.save((Model)((Object)trackingLine));
            }
            trackingLine = new WkfTrackingLine();
            trackingLine.setWkfTracking(wkfTracking);
            trackingLine.setStatus(status);
            trackingLine.setWkfTracking(wkfTracking);
            return (WkfTrackingLine)((Object)this.trackingLineRepo.save((Model)((Object)trackingLine)));
        }
        return null;
    }

    @Transactional
    public void updateTrackingTotal(WkfTracking wkfTracking, String status) {
        WkfTrackingTotal trackingTotal = (WkfTrackingTotal)((Object)this.trackingTotalRepo.all().filter("self.wkfTracking = :wkfTracking and self.status = :status").bind("wkfTracking", (Object)wkfTracking).bind("status", (Object)status).fetchOne());
        if (trackingTotal == null) {
            trackingTotal = new WkfTrackingTotal();
            trackingTotal.setWkfTracking(wkfTracking);
            trackingTotal.setTotalCount(0);
            trackingTotal.setStatus(status);
        }
        trackingTotal.setTotalCount(trackingTotal.getTotalCount() + 1);
        this.trackingTotalRepo.save((Model)((Object)trackingTotal));
    }

    @Transactional
    public void updateTrackingTime(WkfTracking wkfTracking, String status) {
        WkfTrackingTime trackingTime = (WkfTrackingTime)((Object)this.trackingTimeRepo.all().filter("self.wkfTracking = ?1 and self.status = ?2", new Object[]{wkfTracking, this.oldStatus}).fetchOne());
        if (trackingTime != null) {
            BigDecimal days = this.durationHrs.divide(new BigDecimal(24), 2, RoundingMode.HALF_UP);
            BigDecimal totalTimeDays = trackingTime.getTotalTimeDays().add(days);
            trackingTime.setTotalTimeDays(totalTimeDays);
            BigDecimal totalTimeHrs = trackingTime.getTotalTimeHours().add(this.durationHrs);
            trackingTime.setTotalTimeHours(totalTimeHrs);
            this.trackingTimeRepo.save((Model)((Object)trackingTime));
        }
        if ((trackingTime = (WkfTrackingTime)((Object)this.trackingTimeRepo.all().filter("self.wkfTracking = ?1 and self.status = ?2", new Object[]{wkfTracking, status}).fetchOne())) == null) {
            trackingTime = new WkfTrackingTime();
            trackingTime.setWkfTracking(wkfTracking);
            trackingTime.setStatus(status);
            this.trackingTimeRepo.save((Model)((Object)trackingTime));
        }
    }
}

