/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.service.wkf;

import com.axelor.auth.db.Role;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.meta.db.MetaJsonField;
import com.axelor.meta.db.MetaPermission;
import com.axelor.meta.db.MetaPermissionRule;
import com.axelor.meta.db.repo.MetaJsonFieldRepository;
import com.axelor.meta.db.repo.MetaPermissionRepository;
import com.axelor.meta.loader.XMLViews;
import com.axelor.meta.schema.actions.ActionRecord;
import com.axelor.meta.schema.actions.ActionValidate;
import com.axelor.studio.db.Filter;
import com.axelor.studio.db.WkfTransition;
import com.axelor.studio.service.StudioMetaService;
import com.axelor.studio.service.filter.FilterGroovyService;
import com.axelor.studio.service.wkf.WkfService;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WkfTransitionService {
    private WkfService wkfService;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<String> wkfButtonNames;
    @Inject
    private MetaPermissionRepository metaPermissionRepo;
    @Inject
    private FilterGroovyService filterGroovyService;
    @Inject
    private StudioMetaService metaService;
    @Inject
    private MetaJsonFieldRepository jsonFieldRepo;

    @Inject
    protected WkfTransitionService(WkfService wkfService) {
        this.wkfService = wkfService;
    }

    protected List<String[]> process() throws AxelorException {
        this.log.debug("Processing transitions");
        ArrayList<String[]> actions = new ArrayList<String[]>();
        String action = "action-" + this.wkfService.wkfCode;
        String model = this.wkfService.workflow.getIsJson() != false || this.wkfService.workflow.getJsonField() != null ? "com.axelor.meta.db.MetaJsonRecord" : this.wkfService.workflow.getModel();
        this.wkfButtonNames = new ArrayList<String>();
        List<ActionRecord.RecordField> fields = this.proccessTransitions();
        if (!fields.isEmpty()) {
            String xml = this.getActionXML(action, model, fields);
            this.metaService.updateMetaAction(action, "action-record", xml, model);
            actions.add(new String[]{action});
        } else {
            this.metaService.removeMetaActions(action);
        }
        String actionsToRemove = this.wkfService.clearOldButtons(this.wkfButtonNames);
        this.metaService.removeMetaActions(actionsToRemove);
        return actions;
    }

    private List<ActionRecord.RecordField> proccessTransitions() throws AxelorException {
        ArrayList<ActionRecord.RecordField> fields = new ArrayList<ActionRecord.RecordField>();
        Integer buttonSeq = this.wkfService.wkfSequence - 46;
        Integer buttonSeqPreview = this.wkfService.wkfSequencePreview - 46;
        for (WkfTransition transition : this.wkfService.workflow.getTransitions()) {
            String applyCondition;
            String[] wkfFieldInfo = this.wkfService.getWkfFieldInfo(this.wkfService.workflow);
            String wkfFieldName = wkfFieldInfo[0];
            String wkfFieldType = wkfFieldInfo[1];
            MetaJsonField statusPreview = this.jsonFieldRepo.findByName(this.wkfService.wkfCode + wkfFieldName);
            String condition = wkfFieldName + " == " + this.getTyped(transition.getSource().getSequence(), wkfFieldType);
            String conditionPreview = null;
            if (statusPreview != null) {
                conditionPreview = statusPreview.getName() + " == " + this.getTyped(transition.getSource().getSequence(), statusPreview.getType());
            }
            this.log.debug("Processing transition : {}, isButton: {}", (Object)transition.getName(), (Object)transition.getIsButton());
            String filters = this.getFilters(transition.getConditions(), transition.getIsButton(), transition.getIsButton() == false);
            if (filters != null) {
                condition = condition + " && (" + filters + ")";
            }
            if ((applyCondition = this.getFilters(this.wkfService.workflow.getConditions(), transition.getIsButton(), transition.getIsButton() == false)) != null) {
                condition = condition + " && " + applyCondition;
            }
            if (transition.getIsButton().booleanValue()) {
                Integer n = buttonSeq;
                Integer n2 = buttonSeq = Integer.valueOf(buttonSeq + 1);
                n = buttonSeqPreview;
                n2 = buttonSeqPreview = Integer.valueOf(buttonSeqPreview + 1);
                this.addButton(transition, condition, conditionPreview, buttonSeq, buttonSeqPreview);
                continue;
            }
            this.log.debug("Conditions : {}", transition.getConditions());
            ActionRecord.RecordField recordField = new ActionRecord.RecordField();
            recordField.setName(wkfFieldName);
            recordField.setExpression("eval:" + this.getTyped(transition.getTarget().getSequence(), wkfFieldType));
            recordField.setCondition(condition);
            fields.add(recordField);
        }
        return fields;
    }

    private String getFilters(List<Filter> filterList, boolean isButton, boolean isField) throws AxelorException {
        String jsonField;
        String string = jsonField = this.wkfService.workflow.getIsJson() != false ? null : "$" + this.wkfService.workflow.getJsonField();
        if (jsonField != null && jsonField.equals("$null")) {
            jsonField = null;
        }
        String filters = this.filterGroovyService.getGroovyFilters(filterList, jsonField, isButton, isField);
        this.log.debug("Filters : {}", (Object)filters);
        return filters;
    }

    private String getTyped(Integer value, String wkfFieldType) {
        if (wkfFieldType.equals("integer") || wkfFieldType.equals("Integer")) {
            return value.toString();
        }
        return "'" + value + "'";
    }

    private void addButton(WkfTransition transition, String condition, String conditionPreview, Integer sequence, Integer sequencePreview) throws AxelorException {
        String title = transition.getButtonTitle();
        String name = this.wkfService.wkfCode + "Transition" + transition.getId();
        if (name.equals("save") || name.equals("cancel") || name.equals("back")) {
            name = "wkf" + name;
        }
        this.wkfButtonNames.add(name + "Button");
        MetaJsonField button = this.wkfService.getJsonField(name + "Button", "button");
        button.setTitle(title);
        button.setShowIf((this.wkfService.workflow.getIsJson() == false && this.wkfService.workflow.getJsonField() == null ? "$record." : "") + condition);
        button.setSequence(sequence);
        button.setVisibleInGrid(false);
        button.setIsWkf(true);
        button.setWidgetAttrs("{\"colSpan\": \"" + transition.getColSpan() + "\"}");
        button.setOnClick(this.addButtonActions(transition, name, false));
        if (transition.getRoleSet() != null) {
            HashSet<Role> buttonRoles = new HashSet<Role>();
            buttonRoles.addAll(transition.getRoleSet());
            button.setRoles(buttonRoles);
        }
        this.log.debug("Adding button : {}", (Object)button.getName());
        this.wkfService.saveJsonField(button);
        String buttonPreviewName = this.wkfService.wkfCode + this.wkfService.workflow.getCode() + "Transition" + transition.getId() + "Button";
        MetaJsonField buttonPreview = this.wkfService.findJsonField(buttonPreviewName, "com.axelor.studio.db.Wkf");
        if (buttonPreview == null) {
            buttonPreview = (MetaJsonField)((Object)this.jsonFieldRepo.copy((Model)((Object)button), true));
            buttonPreview.setName(buttonPreviewName);
            buttonPreview.setSequence(sequencePreview);
            buttonPreview.setJsonModel(null);
            buttonPreview.setModel("com.axelor.studio.db.Wkf");
            buttonPreview.setModelField("attrs");
            buttonPreview.setShowIf(conditionPreview + " && $record.code == '" + this.wkfService.workflow.getCode() + "' && $record.id != null");
            buttonPreview.setOnClick(this.addButtonActions(transition, name + this.wkfService.workflow.getCode() + "button", true));
        } else {
            buttonPreview.setTitle(title);
        }
        this.wkfService.saveJsonField(buttonPreview);
    }

    private String addButtonActions(WkfTransition transition, String buttonName, boolean isPreviewButton) throws AxelorException {
        String actionName = buttonName.toLowerCase().replace(" ", "-");
        actionName = "action-" + this.wkfService.wkfCode + "-" + actionName;
        String model = this.wkfService.workflow.getIsJson() != false || this.wkfService.workflow.getJsonField() != null ? "com.axelor.meta.db.MetaJsonRecord" : this.wkfService.workflow.getModel();
        ArrayList<String> actions = new ArrayList<String>();
        String xml = "";
        Integer alterType = transition.getAlertTypeSelect();
        String alertMsg = transition.getAlertMsg();
        if (alterType > 0 && alertMsg != null) {
            String type = "alert";
            if (alterType == 2) {
                type = "info";
            }
            String alertAction = actionName + "-alert";
            xml = this.getActionValidateXML(alertAction, type, alertMsg, transition.getConditions());
            this.metaService.updateMetaAction(alertAction, "action-validate", xml, null);
            actions.add(alertAction);
        }
        actions.add("save");
        ArrayList<ActionRecord.RecordField> recordFields = new ArrayList<ActionRecord.RecordField>();
        ActionRecord.RecordField recordField = new ActionRecord.RecordField();
        String[] wkfFieldInfo = this.wkfService.getWkfFieldInfo(this.wkfService.workflow);
        String wkfFieldName = wkfFieldInfo[0];
        String wkfFieldType = wkfFieldInfo[1];
        if (isPreviewButton) {
            MetaJsonField wkfField = this.jsonFieldRepo.findByName(this.wkfService.wkfCode + wkfFieldName);
            wkfFieldName = wkfField.getName();
            wkfFieldType = wkfField.getType();
        }
        recordField.setName(wkfFieldName);
        recordField.setExpression("eval:" + this.getTyped(transition.getTarget().getSequence(), wkfFieldType));
        recordFields.add(recordField);
        actions.add(actionName);
        xml = this.getActionXML(actionName, model, recordFields);
        this.metaService.updateMetaAction(actionName, "action-record", xml, model);
        String successMsg = transition.getSuccessMsg();
        if (successMsg != null) {
            String sucessAction = actionName + "-success";
            xml = this.getActionValidateXML(sucessAction, "notify", successMsg, null);
            this.metaService.updateMetaAction(sucessAction, "action-validate", xml, null);
            actions.add(sucessAction);
        }
        actions.add("save");
        if (isPreviewButton) {
            actions.add("action-group-" + this.wkfService.workflow.getCode());
        } else {
            actions.add("action-group-" + this.wkfService.wkfCode);
        }
        return Joiner.on((String)",").join(actions);
    }

    private String getActionXML(String name, String model, List<ActionRecord.RecordField> recordFields) {
        this.log.debug("Creating action record: {}", (Object)name);
        ActionRecord action = new ActionRecord();
        action.setName(name);
        action.setModel(model);
        action.setFields(recordFields);
        return XMLViews.toXml((Object)action, (boolean)true);
    }

    private String getActionValidateXML(String name, String type, String message, List<Filter> conditions) throws AxelorException {
        ActionValidate actionValidate = new ActionValidate();
        actionValidate.setName(name);
        ArrayList<Object> validators = new ArrayList<Object>();
        String condition = this.getFilters(conditions, false, true);
        switch (type) {
            case "notify": {
                ActionValidate.Notify notify = new ActionValidate.Notify();
                notify.setMessage(message);
                notify.setCondition(condition);
                validators.add(notify);
                break;
            }
            case "info": {
                ActionValidate.Info info = new ActionValidate.Info();
                info.setMessage(message);
                info.setCondition(condition);
                validators.add(info);
                break;
            }
            default: {
                ActionValidate.Alert alert = new ActionValidate.Alert();
                alert.setMessage(message);
                alert.setCondition(condition);
                validators.add(alert);
            }
        }
        actionValidate.setValidators(validators);
        return XMLViews.toXml((Object)actionValidate, (boolean)true);
    }

    @Transactional
    public void addButtonPermissions(String name, String buttonName, Set<Role> roles) {
        if (roles == null || roles.isEmpty()) {
            return;
        }
        MetaPermission permission = this.metaPermissionRepo.findByName(name);
        if (permission == null) {
            permission = new MetaPermission(name);
            permission.setObject(this.wkfService.workflow.getModel());
            MetaPermissionRule rule = new MetaPermissionRule();
            rule.setCanRead(Boolean.valueOf(false));
            rule.setField(buttonName);
            permission.addRule(rule);
            permission = (MetaPermission)this.metaPermissionRepo.save((Model)permission);
        }
        for (Role role : roles) {
            role.addMetaPermission(permission);
            this.wkfService.roleRepo.save((Model)role);
        }
    }

    @Transactional
    public void clearOldMetaPermissions(String name) {
        MetaPermission permission = this.metaPermissionRepo.findByName(name);
        if (permission != null) {
            List oldRoleList = this.wkfService.roleRepo.all().filter("self.metaPermissions.id = ?1", new Object[]{permission.getId()}).fetch();
            for (Role role : oldRoleList) {
                role.removeMetaPermission(permission);
                this.wkfService.roleRepo.save((Model)role);
            }
        }
    }
}

