/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.web;

import com.axelor.common.Inflector;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaView;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.studio.db.ActionBuilder;
import com.axelor.studio.db.ActionBuilderView;
import java.util.ArrayList;
import java.util.List;

public class ActionBuilderController {
    private Inflector inflector;

    public void setViews(ActionRequest request, ActionResponse response) {
        this.inflector = Inflector.getInstance();
        ActionBuilder builder = (ActionBuilder)((Object)request.getContext().asType(ActionBuilder.class));
        String model = builder.getModel();
        boolean isJson = false;
        if (builder.getIsJson() != null) {
            isJson = builder.getIsJson();
        }
        if (builder.getTypeSelect() == 3 && model != null) {
            if (!isJson) {
                model = model.substring(model.lastIndexOf(46) + 1);
                model = this.inflector.dasherize(model);
            }
            ArrayList<ActionBuilderView> views = new ArrayList<ActionBuilderView>();
            this.addActionBuilderView(views, model, "grid", isJson, 0);
            this.addActionBuilderView(views, model, "form", isJson, 1);
            response.setValue("actionBuilderViews", views);
        }
    }

    private void addActionBuilderView(List<ActionBuilderView> views, String model, String type, boolean isJson, int sequence) {
        MetaView view;
        String viewName = model + "-" + type;
        if (isJson) {
            viewName = "custom-model-" + model + "-" + type;
        }
        if ((view = ((MetaViewRepository)Beans.get(MetaViewRepository.class)).findByName(viewName)) == null) {
            return;
        }
        ActionBuilderView builderView = new ActionBuilderView();
        builderView.setViewName(view.getName());
        builderView.setViewType(view.getType());
        builderView.setSequence(sequence);
        views.add(builderView);
    }
}

