/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.studio.web;

import com.axelor.common.ObjectUtils;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaJsonModel;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.studio.db.MenuBuilder;
import com.axelor.studio.db.Wkf;
import com.axelor.studio.db.repo.MenuBuilderRepo;
import com.axelor.studio.db.repo.MenuBuilderRepository;
import com.axelor.studio.db.repo.MetaJsonModelRepo;
import com.axelor.studio.db.repo.WkfRepository;
import com.axelor.studio.service.StudioMetaService;
import com.google.inject.persist.Transactional;
import java.util.stream.Collectors;

public class MetaJsonModelController {
    public void openWorkflow(ActionRequest request, ActionResponse response) {
        MetaJsonModel jsonModel = (MetaJsonModel)((Object)request.getContext().asType(MetaJsonModel.class));
        Wkf wkf = (Wkf)((Object)((WkfRepository)((Object)Beans.get(WkfRepository.class))).all().filter("self.model = ?1", new Object[]{jsonModel.getName()}).fetchOne());
        ActionView.ActionViewBuilder builder = ActionView.define((String)"Workflow").add("form", "wkf-form").model("com.axelor.studio.db.Wkf");
        if (wkf == null) {
            builder.context("_jsonModel", (Object)jsonModel.getName());
        } else {
            builder.context("_showRecord", (Object)wkf.getId());
        }
        response.setView(builder.map());
    }

    public void trackJsonField(ActionRequest request, ActionResponse response) {
        try {
            String jsonFieldTracking;
            MetaJsonModel jsonModel = (MetaJsonModel)((Object)request.getContext().asType(MetaJsonModel.class));
            String string = jsonFieldTracking = request.getContext().get((Object)"jsonFieldTracking") != null ? request.getContext().get((Object)"jsonFieldTracking").toString() : "";
            if (!jsonFieldTracking.isEmpty()) {
                ((StudioMetaService)Beans.get(StudioMetaService.class)).trackingFields(jsonModel, jsonFieldTracking, "Field added");
                response.setValue("$jsonFieldTracking", null);
                return;
            }
            ((StudioMetaService)Beans.get(StudioMetaService.class)).trackJsonField(jsonModel);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setJsonFieldTracking(ActionRequest request, ActionResponse response) {
        try {
            MetaJsonModel jsonModel = (MetaJsonModel)((Object)request.getContext().asType(MetaJsonModel.class));
            if (jsonModel.getId() != null || ObjectUtils.isEmpty(jsonModel.getFields())) {
                response.setValue("$jsonFieldTracking", null);
                return;
            }
            String jsonFields = jsonModel.getFields().stream().map(list -> list.getName()).collect(Collectors.joining(", "));
            response.setValue("$jsonFieldTracking", (Object)jsonFields);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void removeMenuBuilder(ActionRequest request, ActionResponse response) {
        MetaJsonModel metaJsonModel = (MetaJsonModel)((Object)request.getContext().asType(MetaJsonModel.class));
        if (metaJsonModel.getMenuBuilder() != null && metaJsonModel.getMenuBuilder().getId() != null && metaJsonModel.getMenuBuilder().getMetaMenu() != null) {
            MenuBuilder menuBuilder = (MenuBuilder)((Object)((MenuBuilderRepository)((Object)Beans.get(MenuBuilderRepository.class))).find(metaJsonModel.getMenuBuilder().getId()));
            metaJsonModel = (MetaJsonModel)((Object)((MetaJsonModelRepo)((Object)Beans.get(MetaJsonModelRepo.class))).find(metaJsonModel.getId()));
            metaJsonModel.setMenuBuilder(null);
            ((MetaJsonModelRepo)((Object)Beans.get(MetaJsonModelRepo.class))).save(metaJsonModel);
            ((MenuBuilderRepo)((Object)Beans.get(MenuBuilderRepo.class))).remove(menuBuilder);
            response.setReload(true);
        }
    }
}

