/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.helpdesk.service;

import com.axelor.apps.base.db.AppHelpdesk;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.repo.AppHelpdeskRepository;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.publicHoliday.PublicHolidayService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.helpdesk.db.Sla;
import com.axelor.apps.helpdesk.db.Ticket;
import com.axelor.apps.helpdesk.db.repo.SlaRepository;
import com.axelor.apps.helpdesk.db.repo.TicketRepository;
import com.axelor.apps.helpdesk.service.TicketService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDateTime;
import java.util.List;

public class TicketServiceImpl
implements TicketService {
    @Inject
    private SequenceService sequenceService;
    @Inject
    private AppHelpdeskRepository appHelpdeskRepo;
    @Inject
    private TicketRepository ticketRepo;
    @Inject
    private SlaRepository slaRepo;
    @Inject
    private PublicHolidayService publicHolidayService;
    @Inject
    private WeeklyPlanningService weeklyPlanningService;
    private LocalDateTime toDate;

    @Override
    public void computeSeq(Ticket ticket) {
        if (Strings.isNullOrEmpty((String)ticket.getTicketSeq())) {
            String ticketSeq = this.sequenceService.getSequenceNumber("ticket", null);
            ticket.setTicketSeq(ticketSeq);
        }
    }

    @Override
    public void computeSLA(Ticket ticket) {
        AppHelpdesk helpdesk = (AppHelpdesk)((Object)this.appHelpdeskRepo.all().fetchOne());
        if (helpdesk.getIsSla().booleanValue()) {
            Sla sla = (Sla)((Object)this.slaRepo.all().filter("self.team = ?1 AND self.prioritySelect = ?2 AND self.ticketType = ?3", new Object[]{ticket.getAssignedToUser() == null ? null : ticket.getAssignedToUser().getActiveTeam(), ticket.getPrioritySelect(), ticket.getTicketType()}).fetchOne());
            if (sla == null) {
                sla = (Sla)((Object)this.slaRepo.all().filter("self.team = ?1 AND self.prioritySelect = ?2 AND self.ticketType = null OR (self.team = null AND self.prioritySelect = ?2 AND self.ticketType = ?3) OR (self.team = ?1 AND self.prioritySelect = null AND self.ticketType = ?3)", new Object[]{ticket.getAssignedToUser() == null ? null : ticket.getAssignedToUser().getActiveTeam(), ticket.getPrioritySelect(), ticket.getTicketType()}).fetchOne());
            }
            if (sla == null) {
                sla = (Sla)((Object)this.slaRepo.all().filter("self.team = ?1 AND self.prioritySelect = null AND self.ticketType = null OR (self.team = null AND self.prioritySelect = ?2 AND self.ticketType = null) OR (self.team = null AND self.prioritySelect = null AND self.ticketType = ?3)", new Object[]{ticket.getAssignedToUser() == null ? null : ticket.getAssignedToUser().getActiveTeam(), ticket.getPrioritySelect(), ticket.getTicketType()}).fetchOne());
            }
            if (sla == null) {
                sla = (Sla)((Object)this.slaRepo.all().filter("self.team = null AND self.prioritySelect = null AND self.ticketType = null").fetchOne());
            }
            if (sla != null) {
                ticket.setSlaPolicy(sla);
                try {
                    this.computeDuration(ticket, sla);
                }
                catch (AxelorException e) {
                    e.printStackTrace();
                }
            } else {
                ticket.setSlaPolicy(null);
            }
        }
    }

    private void computeDuration(Ticket ticket, Sla sla) throws AxelorException {
        if (sla.getIsWorkingDays().booleanValue() && ticket.getAssignedToUser() != null && ticket.getAssignedToUser().getActiveCompany() != null && ticket.getAssignedToUser().getActiveCompany().getWeeklyPlanning() != null && ticket.getAssignedToUser().getActiveCompany().getPublicHolidayEventsPlanning() != null) {
            if (sla.getDays() > 0) {
                LocalDateTime fromDate = ticket.getStartDateT().plusDays(1L);
                this.calculateWorkingDays(fromDate, ticket.getAssignedToUser().getActiveCompany(), sla.getDays());
                ticket.setDeadlineDateT(this.toDate.plusHours(sla.getHours().intValue()));
            } else {
                ticket.setDeadlineDateT(ticket.getStartDateT().plusHours(sla.getHours().intValue()));
            }
        } else {
            this.calculateAllDays(ticket, sla);
        }
    }

    private void calculateAllDays(Ticket ticket, Sla sla) {
        LocalDateTime localDateTime = ticket.getStartDateT().plusDays(sla.getDays().intValue());
        localDateTime = localDateTime.plusHours(sla.getHours().intValue());
        ticket.setDeadlineDateT(localDateTime);
    }

    private void calculateWorkingDays(LocalDateTime fromDate, Company company, int days) throws AxelorException {
        if (this.weeklyPlanningService.getWorkingDayValueInDays(company.getWeeklyPlanning(), fromDate.toLocalDate()) == 0.0 || this.publicHolidayService.checkPublicHolidayDay(fromDate.toLocalDate(), company.getPublicHolidayEventsPlanning())) {
            fromDate = fromDate.plusDays(1L);
            this.calculateWorkingDays(fromDate, company, days);
        } else {
            this.toDate = fromDate;
            if (--days != 0) {
                fromDate = fromDate.plusDays(1L);
                this.calculateWorkingDays(fromDate, company, days);
            }
        }
    }

    @Override
    public void checkSLAcompleted(Ticket ticket) {
        if (ticket.getSlaPolicy() != null) {
            LocalDateTime currentDate = LocalDateTime.now();
            LocalDateTime deadlineDateT = ticket.getDeadlineDateT();
            ticket.setIsSlaCompleted(ticket.getStatusSelect() >= ticket.getSlaPolicy().getReachStageSelect() && (currentDate.isBefore(deadlineDateT) || currentDate.isEqual(deadlineDateT)));
        }
    }

    @Override
    @Transactional
    public void assignToMeTicket(Long id, List<?> ids) {
        if (id != null) {
            Ticket ticket = (Ticket)((Object)this.ticketRepo.find(id));
            ticket.setAssignedToUser(AuthUtils.getUser());
            this.ticketRepo.save((Model)((Object)ticket));
        } else if (!ids.isEmpty()) {
            for (Ticket ticket : this.ticketRepo.all().filter("id in ?1", new Object[]{ids}).fetch()) {
                ticket.setAssignedToUser(AuthUtils.getUser());
                this.ticketRepo.save((Model)((Object)ticket));
            }
        }
    }
}

